/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.sponge;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.SpongePlugin;
import com.djrapitops.plugin.api.systems.TaskCenter;
import com.djrapitops.plugin.task.IRunnable;
import com.djrapitops.plugin.task.ITask;
import com.djrapitops.plugin.task.sponge.AbsSpongeTask;
import org.spongepowered.api.scheduler.Task;

public abstract class AbsSpongeRunnable<T extends IPlugin>
implements IRunnable,
Runnable {
    private final T plugin;
    private final String name;
    private ITask task;

    public AbsSpongeRunnable(String name, IPlugin plugin) {
        if (!(plugin instanceof SpongePlugin)) {
            throw new IllegalArgumentException("Given plugin was not of correct type");
        }
        this.plugin = plugin;
        this.name = name;
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public void cancel() {
        TaskCenter.taskCancelled(this.plugin.getClass(), this.name, this.getTaskId());
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public int getTaskId() {
        return 0;
    }

    @Override
    public ITask runTask() {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).submit(this.plugin));
        return this.task;
    }

    @Override
    public ITask runTaskAsynchronously() {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).async().submit(this.plugin));
        return this.task;
    }

    @Override
    public ITask runTaskLater(long delay) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).delayTicks(delay).submit(this.plugin));
        return this.task;
    }

    @Override
    public ITask runTaskLaterAsynchronously(long delay) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).async().delayTicks(delay).submit(this.plugin));
        return this.task;
    }

    @Override
    public ITask runTaskTimer(long delay, long period) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).delayTicks(delay).intervalTicks(period).submit(this.plugin));
        return this.task;
    }

    @Override
    public ITask runTaskTimerAsynchronously(long delay, long period) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).async().delayTicks(delay).intervalTicks(period).submit(this.plugin));
        return this.task;
    }
}

