/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.bungee;

import com.djrapitops.plugin.BungeePlugin;
import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.api.systems.TaskCenter;
import com.djrapitops.plugin.task.IRunnable;
import com.djrapitops.plugin.task.ITask;
import com.djrapitops.plugin.task.bungee.AbsBungeeTask;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.scheduler.TaskScheduler;

public abstract class AbsBungeeRunnable<T extends BungeePlugin>
implements IRunnable,
Runnable {
    private final T plugin;
    private final String name;
    private final TaskScheduler scheduler;
    private int id = -1;

    public AbsBungeeRunnable(String name, IPlugin plugin) {
        this.name = name;
        if (!(plugin instanceof BungeePlugin)) {
            throw new IllegalArgumentException("Given plugin was not of correct type");
        }
        this.plugin = (BungeePlugin)plugin;
        this.scheduler = this.plugin.getProxy().getScheduler();
    }

    @Override
    public abstract void run();

    @Override
    public ITask runTask() {
        return this.runTaskAsynchronously();
    }

    @Override
    public ITask runTaskAsynchronously() {
        AbsBungeeTask task = new AbsBungeeTask(this.scheduler.runAsync(this.plugin, (Runnable)this));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskLater(long delay) {
        return this.runTaskLaterAsynchronously(delay);
    }

    @Override
    public ITask runTaskLaterAsynchronously(long delay) {
        AbsBungeeTask task = new AbsBungeeTask(this.scheduler.schedule(this.plugin, (Runnable)this, TimeAmount.ticksToMillis(delay), TimeUnit.MILLISECONDS));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskTimer(long delay, long period) {
        return this.runTaskTimerAsynchronously(delay, period);
    }

    @Override
    public ITask runTaskTimerAsynchronously(long delay, long period) {
        AbsBungeeTask task = new AbsBungeeTask(this.scheduler.schedule(this.plugin, (Runnable)this, TimeAmount.ticksToMillis(delay), TimeAmount.ticksToMillis(period), TimeUnit.MILLISECONDS));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public synchronized void cancel() throws IllegalStateException {
        TaskCenter.taskCancelled(this.plugin.getClass(), this.name, this.id);
        this.scheduler.cancel(this.id);
    }

    @Override
    public int getTaskId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.name;
    }
}

