/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.bukkit;

import com.djrapitops.plugin.BukkitPlugin;
import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.api.systems.TaskCenter;
import com.djrapitops.plugin.task.IRunnable;
import com.djrapitops.plugin.task.ITask;
import com.djrapitops.plugin.task.bukkit.AbsBukkitTask;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbsBukkitRunnable<T extends BukkitPlugin>
extends BukkitRunnable
implements IRunnable,
Runnable {
    private final T plugin;
    private final String name;
    private int id = -1;

    public AbsBukkitRunnable(String name, IPlugin plugin) {
        this.name = name;
        if (!(plugin instanceof BukkitPlugin)) {
            throw new IllegalArgumentException("Given plugin was not of correct type");
        }
        this.plugin = (BukkitPlugin)plugin;
    }

    @Override
    public abstract void run();

    @Override
    public ITask runTask() {
        AbsBukkitTask task = new AbsBukkitTask(super.runTask(this.plugin));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskAsynchronously() {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskAsynchronously(this.plugin));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskLater(long delay) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskLater(this.plugin, delay));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskLaterAsynchronously(long delay) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskLaterAsynchronously(this.plugin, delay));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskTimer(long delay, long period) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskTimer(this.plugin, delay, period));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public ITask runTaskTimerAsynchronously(long delay, long period) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskTimerAsynchronously(this.plugin, delay, period));
        this.id = task.getTaskId();
        TaskCenter.taskStarted(this.plugin.getClass(), task, this.name, this);
        return task;
    }

    @Override
    public synchronized void cancel() throws IllegalStateException {
        TaskCenter.taskCancelled(this.plugin.getClass(), this.name, this.id);
        this.plugin.getServer().getScheduler().cancelTask(this.id);
        super.cancel();
    }

    @Override
    public String getTaskName() {
        return this.name;
    }
}

