/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.StaticHolder;
import com.djrapitops.plugin.api.Check;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.IRunnable;
import com.djrapitops.plugin.task.ThreadRunnable;
import com.djrapitops.plugin.task.bukkit.AbsBukkitRunnable;
import com.djrapitops.plugin.task.bungee.AbsBungeeRunnable;
import com.djrapitops.plugin.task.sponge.AbsSpongeRunnable;
import com.djrapitops.plugin.utilities.StackUtils;

public class RunnableFactory {
    private static boolean testMode = false;

    public static IRunnable createNew(AbsRunnable runnable) {
        return RunnableFactory.createNew(runnable.getName(), runnable);
    }

    public static IRunnable createNew(String name, final AbsRunnable runnable) {
        if (!testMode) {
            try {
                Class callingPlugin = StackUtils.getCallingPlugin();
                IPlugin instance = StaticHolder.getInstance(callingPlugin);
                StaticHolder.saveInstance(runnable.getClass(), callingPlugin);
                if (Check.isBukkitAvailable()) {
                    return new AbsBukkitRunnable(name, instance){

                        @Override
                        public void run() {
                            runnable.setCancellable(this);
                            runnable.run();
                        }
                    };
                }
                if (Check.isBungeeAvailable()) {
                    return new AbsBungeeRunnable(name, instance){

                        @Override
                        public void run() {
                            runnable.setCancellable(this);
                            runnable.run();
                        }
                    };
                }
                if (Check.isSpongeAvailable()) {
                    return new AbsSpongeRunnable(name, instance){

                        @Override
                        public void run() {
                            runnable.setCancellable(this);
                            runnable.run();
                        }
                    };
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return new ThreadRunnable(name, 0, runnable);
    }

    public static void activateTestMode() {
        testMode = true;
    }
}

