/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.bungee;

import com.djrapitops.plugin.command.ISender;
import com.djrapitops.plugin.command.SenderType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ConnectedPlayer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeCMDSender
implements ISender {
    private final CommandSender cs;

    public BungeeCMDSender(CommandSender cs) {
        this.cs = cs;
    }

    @Override
    public String getName() {
        return this.cs.getName();
    }

    @Override
    public void sendMessage(String string) {
        ComponentBuilder c = new ComponentBuilder(string);
        this.cs.sendMessage(c.create());
    }

    @Override
    public void sendLink(String pretext, String linkMsg, String url) {
        TextComponent message = new TextComponent(pretext);
        TextComponent link = new TextComponent(linkMsg);
        link.setUnderlined(Boolean.valueOf(true));
        message.addExtra((BaseComponent)link);
        message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        this.cs.sendMessage((BaseComponent)message);
    }

    @Override
    public void sendLink(String linkMsg, String url) {
        this.sendLink("", linkMsg, url);
    }

    @Override
    public boolean hasPermission(String string) {
        return this.cs.hasPermission(string);
    }

    @Override
    public void sendMessage(String[] strings) {
        for (int i = 1; i < strings.length; ++i) {
            this.sendMessage(strings[i]);
        }
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public SenderType getSenderType() {
        return this.cs instanceof ConnectedPlayer ? SenderType.PLAYER : (this.cs instanceof ProxiedPlayer ? SenderType.PROXY_PLAYER : SenderType.CONSOLE);
    }

    public CommandSender getSender() {
        return this.cs;
    }
}

