/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.StaticHolder;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.HelpCommand;
import com.djrapitops.plugin.command.ISender;
import com.djrapitops.plugin.command.SubCommand;
import com.djrapitops.plugin.settings.ColorScheme;
import com.djrapitops.plugin.settings.DefaultMessages;
import com.djrapitops.plugin.utilities.FormatUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class TreeCommand<T extends IPlugin>
extends SubCommand {
    protected final T plugin;
    private final List<SubCommand> commands;
    private String defaultCommand = "help";
    private String helpPrefix = "";
    private ColorScheme cs = new ColorScheme("\u00a77", "\u00a7f", "\u00a78");

    public TreeCommand(T plugin, SubCommand values, String helpPrefix) {
        this(plugin, values.getName(), values.getCommandType(), values.getPermission(), values.getUsage(), helpPrefix);
    }

    public TreeCommand(T plugin, String name, CommandType type, String permission, String usage, String helpPrefix) {
        super(name, type, permission, usage, "");
        this.plugin = plugin;
        this.helpPrefix = helpPrefix;
        this.commands = new ArrayList<SubCommand>();
        this.add(new HelpCommand<T>(plugin, this));
        this.addCommands();
    }

    public void setDefaultCommand(String defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public void add(SubCommand ... commands) {
        for (SubCommand command : commands) {
            this.commands.add(command);
            StaticHolder.saveInstance(command.getClass(), this.plugin.getClass());
        }
    }

    public abstract void addCommands();

    public List<SubCommand> getCommands() {
        return this.commands;
    }

    public SubCommand getCommand(String name) {
        for (SubCommand command : this.commands) {
            String[] aliases;
            for (String alias : aliases = command.getName().split(",")) {
                if (!alias.trim().equalsIgnoreCase(name)) continue;
                return command;
            }
        }
        return null;
    }

    private void sendDefaultCommand(ISender sender, String commandLabel, String[] args) {
        String command = this.defaultCommand;
        if (args.length < 1) {
            command = "help";
        }
        this.onCommand(sender, commandLabel, FormatUtils.mergeArrays({command}, args));
    }

    @Override
    public boolean onCommand(ISender sender, String commandLabel, String[] args) {
        boolean console;
        if (args.length < 1) {
            this.sendDefaultCommand(sender, commandLabel, args);
            return true;
        }
        SubCommand command = this.getCommand(args[0]);
        if (command == null) {
            this.sendDefaultCommand(sender, commandLabel, args);
            return true;
        }
        boolean bl = console = !CommandUtils.isPlayer(sender);
        if (!command.hasPermission(sender)) {
            sender.sendMessage("\u00a7c[" + this.plugin.getClass().getSimpleName() + "] " + (Object)((Object)DefaultMessages.COMMAND_NO_PERMISSION));
            return true;
        }
        CommandType cType = command.getCommandType();
        if (cType == CommandType.ALL_WITH_ARGS && args.length < 2 || console && args.length < 2 && cType == CommandType.PLAYER_OR_ARGS) {
            sender.sendMessage("\u00a7c[" + this.plugin.getClass().getSimpleName() + "] " + DefaultMessages.COMMAND_REQUIRES_ARGUMENTS.parse("1") + " " + command.getArguments());
            return true;
        }
        if (console && cType == CommandType.PLAYER) {
            sender.sendMessage("\u00a7c[" + this.plugin.getClass().getSimpleName() + "] " + (Object)((Object)DefaultMessages.COMMAND_SENDER_NOT_PLAYER));
            return true;
        }
        if (args[args.length - 1].equals("?")) {
            sender.sendMessage(command.getInDepthHelp());
            return true;
        }
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        try {
            command.onCommand(sender, commandLabel, realArgs);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7c[" + this.plugin.getClass().getSimpleName() + "] Number Required: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7c[" + this.plugin.getClass().getSimpleName() + "] Bad Argument: " + e.getMessage());
        }
        catch (IllegalStateException e) {
            sender.sendMessage("\u00a7c[" + this.plugin.getClass().getSimpleName() + "] Bad State: " + e.getMessage());
        }
        return true;
    }

    public String getHelpCmd() {
        return this.helpPrefix;
    }

    public ColorScheme getColorScheme() {
        return this.cs;
    }

    public TreeCommand<T> setColorScheme(ColorScheme cs) {
        this.cs = cs;
        return this;
    }
}

