/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command;

import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.ISender;

public abstract class SubCommand {
    private final CommandType commandType;
    private final String name;
    private final String permission;
    private final String usage;
    private final String arguments;
    private String[] inDepthHelp;

    public SubCommand(String name, CommandType type, String permission, String usage, String arguments) {
        this.commandType = type;
        this.name = name;
        this.permission = permission;
        this.usage = usage;
        this.arguments = arguments;
        this.inDepthHelp = this.addHelp();
    }

    public SubCommand(String name, CommandType type) {
        this(name, type, "");
    }

    public SubCommand(String name, CommandType type, String permission) {
        this(name, type, permission, "");
    }

    public SubCommand(String name, CommandType type, String permission, String usage) {
        this(name, type, permission, usage, "");
    }

    public abstract boolean onCommand(ISender var1, String var2, String[] var3);

    public CommandType getCommandType() {
        return this.commandType;
    }

    public boolean hasPermission(ISender sender) {
        return this.permission.isEmpty() || !CommandUtils.isPlayer(sender) || sender.hasPermission(this.permission);
    }

    public String getName() {
        return this.name;
    }

    public String getFirstName() {
        if (this.name.contains(",")) {
            return this.name.split(",")[0];
        }
        return this.name.trim();
    }

    public String getPermission() {
        return this.permission;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String[] getInDepthHelp() {
        if (this.inDepthHelp != null) {
            return this.inDepthHelp;
        }
        return new String[]{this.usage};
    }

    public String[] addHelp() {
        return null;
    }

    public void setInDepthHelp(String[] inDepthHelp) {
        this.inDepthHelp = inDepthHelp;
    }
}

