/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.ISender;
import com.djrapitops.plugin.command.SubCommand;
import com.djrapitops.plugin.command.TreeCommand;
import com.djrapitops.plugin.settings.ColorScheme;
import com.djrapitops.plugin.settings.DefaultMessages;
import com.djrapitops.plugin.utilities.Format;
import java.util.List;

class HelpCommand<T extends IPlugin>
extends SubCommand {
    private final TreeCommand<T> command;

    public HelpCommand(T plugin, TreeCommand<T> command) {
        super("help,?", CommandType.ALL, command.getPermission(), "Show help for the command.");
        this.command = command;
    }

    @Override
    public boolean onCommand(ISender sender, String commandLabel, String[] args) {
        boolean isConsole = !CommandUtils.isPlayer(sender);
        ColorScheme cs = this.command.getColorScheme();
        String oColor = cs.getMainColor();
        String sColor = cs.getSecondaryColor();
        String tColor = cs.getTertiaryColor();
        sender.sendMessage(tColor + DefaultMessages.ARROWS_RIGHT.parse() + oColor + " " + new Format(this.command.getFirstName()).capitalize() + " Help");
        List<SubCommand> commands = this.command.getCommands();
        commands.stream().filter(cmd -> !cmd.getName().equalsIgnoreCase(this.getName())).filter(cmd -> cmd.hasPermission(sender)).filter(cmd -> !isConsole || cmd.getCommandType() != CommandType.PLAYER).map(cmd -> tColor + " " + DefaultMessages.BALL.toString() + oColor + " /" + this.command.getHelpCmd() + " " + cmd.getFirstName() + " " + cmd.getArguments() + tColor + " - " + cmd.getUsage()).forEach(sender::sendMessage);
        sender.sendMessage(sColor + " Add ? to the end of the command for more help");
        sender.sendMessage(tColor + DefaultMessages.ARROWS_RIGHT.parse());
        return true;
    }
}

