/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility.log;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FileLogger {
    public static void appendToFile(File file, String ... lines) throws IOException {
        FileLogger.appendToFile(file, Arrays.asList(lines));
    }

    public static void logToFile(File file, List<String> lines) throws IOException {
        Files.write(file.toPath(), lines, Charset.forName("UTF-8"), new OpenOption[0]);
    }

    public static void appendToFile(File file, List<String> lines) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        Files.write(file.toPath(), lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
    }

    public static List<String> readContents(File file) throws IOException {
        return Files.lines(file.toPath(), Charset.forName("UTF-8")).collect(Collectors.toList());
    }

    public static int getIndentation(String line) {
        int indentation = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++indentation;
        }
        return indentation;
    }
}

