/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility.log;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.api.utility.log.FileLogger;
import com.djrapitops.plugin.utilities.FormatUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ErrorLogger {
    private static List<String> getStackTrace(Throwable e) {
        ArrayList<String> trace = new ArrayList<String>();
        trace.add(e.toString());
        for (StackTraceElement element : e.getStackTrace()) {
            trace.add("   " + element);
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            trace.add("Caused by:");
            trace.addAll(ErrorLogger.getStackTrace(cause));
        }
        return trace;
    }

    public static void logThrowable(Throwable e, File logsFolder) throws IOException {
        File errorFile = new File(logsFolder, "ErrorLog.txt");
        if (!errorFile.exists()) {
            errorFile.createNewFile();
        }
        List<String> stackTrace = ErrorLogger.getStackTrace(e);
        stackTrace.add("Error was logged: " + FormatUtils.formatTimeStampSecond(TimeAmount.currentMs()));
        FileLogger.appendToFile(errorFile, stackTrace);
    }

    public static TreeMap<String, List<String>> getLoggedErrors(IPlugin plugin) throws IOException {
        File logsFolder = new File(plugin.getDataFolder(), "logs");
        File errorFile = new File(logsFolder, "ErrorLog.txt");
        if (!logsFolder.exists() || !errorFile.exists()) {
            return new TreeMap<String, List<String>>();
        }
        try (Stream<String> s = Files.lines(errorFile.toPath(), Charset.forName("UTF-8"));){
            List lines = s.collect(Collectors.toList());
            TreeMap errors = new TreeMap();
            ArrayList<String> errorLines = new ArrayList<String>();
            for (String line : lines) {
                if (line.startsWith("Error was logged: ")) {
                    errors.put(line, errorLines);
                    errorLines = new ArrayList();
                    continue;
                }
                errorLines.add(line);
            }
            TreeMap treeMap = errors;
            return treeMap;
        }
    }
}

