/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility.log;

import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.api.utility.log.DebugInfo;
import com.djrapitops.plugin.utilities.StackUtils;
import java.util.HashMap;
import java.util.Map;

public class DebugLog {
    private static final Map<Class, Map<String, DebugInfo>> debugInfo = new HashMap<Class, Map<String, DebugInfo>>();

    public static DebugInfo logDebug(String task, String message) {
        return DebugLog.getDebug(task).addLine(message, TimeAmount.currentMs());
    }

    public static DebugInfo logDebug(String task, String ... messages) {
        DebugInfo debug = DebugLog.getDebug(task);
        long time = TimeAmount.currentMs();
        for (String message : messages) {
            debug.addLine(message, time);
        }
        return debug;
    }

    public static DebugInfo getDebug(String task) {
        Class callingPlugin = StackUtils.getCallingPlugin();
        Map debugInfos = debugInfo.getOrDefault(callingPlugin, new HashMap());
        DebugInfo info = debugInfos.getOrDefault(task, new DebugInfo(callingPlugin, TimeAmount.currentMs(), task));
        debugInfos.put(task, info);
        debugInfo.put(callingPlugin, debugInfos);
        return info;
    }

    public static Map<String, DebugInfo> getAllDebugInfo() {
        return DebugLog.getAllDebugInfo(StackUtils.getCallingPlugin());
    }

    public static Map<String, DebugInfo> getAllDebugInfo(Class callingPlugin) {
        return debugInfo.getOrDefault(callingPlugin, new HashMap());
    }

    public static void logDebug(String task) {
        DebugLog.getDebug(task).toLog();
    }

    public static void logDebug(String task, long time) {
        DebugLog.getDebug(task).toLog(time);
    }

    public static void clearDebug(String task) {
        Class callingPlugin = StackUtils.getCallingPlugin();
        Map debugInfos = debugInfo.getOrDefault(callingPlugin, new HashMap());
        debugInfos.remove(task);
    }

    public static void pluginDisabled(Class plugin) {
        debugInfo.remove(plugin);
    }
}

