/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility.log;

import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.api.utility.log.DebugLog;
import com.djrapitops.plugin.api.utility.log.Log;
import com.djrapitops.plugin.utilities.FormatUtils;
import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DebugInfo {
    private final Class sourcePlugin;
    private final String task;
    private final List<String> msg;
    private final long firstCallTime;

    public DebugInfo(Class sourcePlugin, long time, String task) {
        Verify.nullCheck(sourcePlugin, task);
        this.sourcePlugin = sourcePlugin;
        this.task = task;
        this.msg = Collections.synchronizedList(new ArrayList());
        this.firstCallTime = time;
        this.addHeader();
    }

    private String timeStamp(long time) {
        return FormatUtils.formatTimeStampSecond(time);
    }

    public DebugInfo addLine(String line) {
        this.addLine(line, TimeAmount.currentMs());
        return this;
    }

    private void addHeader() {
        if (this.msg.isEmpty()) {
            this.msg.add("|                  | " + this.task + " (" + this.timeStamp(this.firstCallTime) + ") ------------");
        }
    }

    public DebugInfo addLine(String line, long time) {
        this.addHeader();
        this.msg.add("| " + this.timeStamp(time) + " | " + line);
        return this;
    }

    public DebugInfo addLines(Collection<String> lines) {
        this.addHeader();
        for (String line : lines) {
            this.msg.add("|                  | " + line);
        }
        return this;
    }

    public DebugInfo addEmptyLine() {
        this.addHeader();
        this.msg.add("|");
        return this;
    }

    public void toLog() {
        this.toLog(null);
    }

    public void toLog(Long time) {
        if (this.msg.size() > 1) {
            this.msg.add(this.getFooter(time));
            Log.debug(this.msg);
        }
        DebugLog.clearDebug(this.task);
    }

    private String getFooter(Long time) {
        int footerMaxLength = this.msg.get(0).length();
        StringBuilder footer = new StringBuilder(footerMaxLength);
        footer.append("| ---------------- | ");
        if (time != null) {
            footer.append(this.task).append(" ");
            footer.append(time).append(" ms ");
        }
        while (footer.length() < footerMaxLength) {
            footer.append("-");
        }
        return footer.toString();
    }

    public String getLastLine() {
        if (this.msg.isEmpty()) {
            return "No information.";
        }
        return this.msg.get(this.msg.size() - 1);
    }
}

