/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.utilities.FormatUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;

public class Version {
    private static <T extends IPlugin> String getGitVersion(String url) throws IOException {
        URL githubUrl = new URL(url);
        String lineWithVersion = "";
        Scanner websiteScanner = new Scanner(githubUrl.openStream());
        while (websiteScanner.hasNextLine()) {
            String line = websiteScanner.nextLine();
            if (!line.toLowerCase().contains("version")) continue;
            lineWithVersion = line;
            break;
        }
        return lineWithVersion.split(": ")[1];
    }

    private static boolean isNewVersionAvailable(String currentVersion, String newVersion) {
        long currentVersionNumber;
        long newestVersionNumber = FormatUtils.parseVersionNumber(newVersion);
        return newestVersionNumber > (currentVersionNumber = FormatUtils.parseVersionNumber(currentVersion));
    }

    public static boolean checkVersion(String version, String versionStringUrl) throws IOException {
        boolean gitHub = versionStringUrl.contains("raw.githubusercontent.com");
        boolean spigot = versionStringUrl.contains("spigotmc.org");
        try {
            if (gitHub) {
                return Version.isNewVersionAvailable(version, Version.getGitVersion(versionStringUrl));
            }
            if (spigot) {
                return Version.isNewVersionAvailable(version, Version.getSpigotVersion(versionStringUrl));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Version fetch error, address: " + versionStringUrl, e);
        }
        throw new IOException("Version can not be fetched from this address: " + versionStringUrl);
    }

    /*
     * Exception decompiling
     */
    private static String getSpigotVersion(String versionStringUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 40[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

