/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility;

import com.djrapitops.plugin.utilities.Verify;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EnumUtility {
    public static <T> List<T> getSupportedEnumValues(Class<T> clazz, String ... names) throws NullPointerException {
        Verify.nullCheck(clazz, names);
        try {
            List<String> wantedNames = EnumUtility.getWantedNames(names);
            Method method = clazz.getMethod("values", new Class[0]);
            Verify.nullCheck(method);
            Object[] values = (Object[])method.invoke(clazz, new Object[0]);
            return EnumUtility.getSupportedValues(values, wantedNames);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return new ArrayList();
        }
    }

    private static List<String> getWantedNames(String[] names) {
        return Arrays.stream(names).filter(Objects::nonNull).map(String::toUpperCase).collect(Collectors.toList());
    }

    private static <T> List<T> getSupportedValues(T[] values, List<String> materialNames) {
        return Arrays.stream(values).filter(Objects::nonNull).filter(obj -> {
            try {
                String name = (String)obj.getClass().getMethod("name", new Class[0]).invoke(obj, new Object[0]);
                return Verify.contains(name, materialNames);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                return false;
            }
        }).collect(Collectors.toList());
    }
}

