/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.systems;

import com.djrapitops.plugin.api.utility.log.Log;
import com.djrapitops.plugin.task.IRunnable;
import com.djrapitops.plugin.task.ITask;
import com.djrapitops.plugin.utilities.StackUtils;
import com.djrapitops.plugin.utilities.status.obj.TaskInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TaskCenter {
    private static final Map<Class, List<TaskInfo>> taskInfo = new HashMap<Class, List<TaskInfo>>();
    private static final Map<Class, List<IRunnable>> tasks = new HashMap<Class, List<IRunnable>>();

    public static void taskStarted(Class plugin, ITask task, String name, IRunnable run) {
        TaskInfo info = new TaskInfo(name, task.isSync(), "Started", task.getTaskId());
        List taskInfoList = taskInfo.getOrDefault(plugin, new ArrayList());
        taskInfoList.add(info);
        taskInfo.put(plugin, taskInfoList);
        List taskList = tasks.getOrDefault(plugin, new ArrayList());
        taskList.add(run);
        tasks.put(plugin, taskList);
        Log.debug(plugin, "Started task " + info);
    }

    public static void cancelAllKnownTasks() {
        TaskCenter.cancelAllKnownTasks(StackUtils.getCallingPlugin());
    }

    public static void cancelAllKnownTasks(Class plugin) {
        List taskList = tasks.getOrDefault(plugin, new ArrayList());
        for (IRunnable iRunnable : new ArrayList(taskList)) {
            try {
                iRunnable.cancel();
                TaskCenter.taskCancelled(plugin, iRunnable.getTaskName(), iRunnable.getTaskId());
            }
            catch (Exception exception) {}
        }
        tasks.remove(plugin);
        taskInfo.remove(plugin);
    }

    public static void taskCancelled(Class plugin, String name, int id) {
        List<TaskInfo> task = taskInfo.get(plugin);
        Optional<TaskInfo> first = task.stream().filter(t -> t.getName().equals(name) && t.getId() == id).findFirst();
        first.ifPresent(info -> {
            Log.debug(plugin, "Ended task " + info);
            task.remove(info);
        });
    }

    public static TaskInfo getMatchingTask(String name, int id) {
        for (List<TaskInfo> tasks : taskInfo.values()) {
            for (TaskInfo task : tasks) {
                if (task.getId() != id || !name.equals(task.getName())) continue;
                return task;
            }
        }
        return null;
    }

    public static String getTaskName(int id) {
        return taskInfo.values().stream().flatMap(Collection::stream).filter(i -> i.getId() == id).findFirst().map(TaskInfo::getName).orElse("Unknown");
    }

    public static String[] getTasks(Class plugin) {
        return (String[])new ArrayList(taskInfo.get(plugin)).stream().map(task -> "Task " + task).sorted().toArray(String[]::new);
    }

    public static int getTaskCount(Class plugin) {
        return taskInfo.get(plugin).size();
    }
}

