/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.systems;

import com.djrapitops.plugin.api.Priority;
import com.djrapitops.plugin.utilities.Format;
import com.djrapitops.plugin.utilities.StackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class NotificationCenter {
    private static final Map<Class, Map<Priority, List<String>>> notifications = new HashMap<Class, Map<Priority, List<String>>>();

    public static void addNotification(Priority priority, String message) {
        Class callingPlugin = StackUtils.getCallingPlugin();
        Map notificationMap = notifications.computeIfAbsent(callingPlugin, p -> new HashMap());
        notificationMap.computeIfAbsent(priority, p -> new ArrayList()).add(message);
    }

    public static void checkNotifications(Player player) {
        if (player.isOp() || player.hasPermission("apf.notify")) {
            for (String msg : NotificationCenter.getNotifications()) {
                player.sendMessage(msg);
            }
        }
    }

    public static List<String> getNotifications() {
        return NotificationCenter.getNotifications(StackUtils.getCallingPlugin());
    }

    public static List<String> getNotifications(Class callingPlugin) {
        String prefix = "[" + callingPlugin.getSimpleName() + "]";
        ArrayList<String> messages = new ArrayList<String>();
        Map notificationMap = notifications.getOrDefault(callingPlugin, new HashMap());
        for (Priority p : new Priority[]{Priority.HIGH, Priority.MEDIUM, Priority.LOW}) {
            String priority = Format.create(p.name()).capitalize().toString();
            List msgs = (List)notificationMap.get((Object)p);
            if (msgs == null) continue;
            messages.addAll(msgs.stream().map(notification -> p.getColor() + prefix + " " + priority + "\u00a7r " + notification).collect(Collectors.toList()));
        }
        return messages;
    }
}

