/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.config;

import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigNode {
    private final String key;
    ConfigNode parent;
    List<String> childOrder;
    int depth;
    private Map<String, ConfigNode> children;
    private List<String> comment;
    private String value;

    public ConfigNode(String key, ConfigNode parent, String value) {
        this.key = key;
        this.parent = parent;
        this.value = value;
        this.childOrder = new ArrayList<String>();
        this.children = new HashMap<String, ConfigNode>();
        this.comment = new ArrayList<String>();
    }

    public ConfigNode getParent() {
        return this.parent;
    }

    public Map<String, ConfigNode> getChildren() {
        return this.children;
    }

    public List<String> getKeysInOrder() {
        return this.childOrder;
    }

    public String getString(String path) {
        return this.getConfigNode(path).getString();
    }

    public String getString() {
        return this.getStringFrom(this.value);
    }

    private String getStringFrom(String value) {
        boolean surroundedWithDoubleQuotes;
        String s = value.trim();
        boolean surroundedWithSingleQuotes = s.startsWith("'") && s.endsWith("'");
        boolean bl = surroundedWithDoubleQuotes = s.startsWith("\"") && s.endsWith("\"");
        if (surroundedWithSingleQuotes || surroundedWithDoubleQuotes) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public boolean getBoolean(String path) {
        return this.getConfigNode(path).getBoolean();
    }

    public boolean getBoolean() {
        return Verify.equalsOne(this.value, "true", "'true'", "\"true\"");
    }

    public int getInt(String path) {
        return this.getConfigNode(path).getInt();
    }

    public int getInt() {
        return this.getInteger(this.value);
    }

    private int getInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLong(String path) {
        return this.getConfigNode(path).getLong();
    }

    public long getLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public double getDouble(String path) {
        return this.getConfigNode(path).getDouble();
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value.replace(',', '.'));
            }
            catch (NumberFormatException e2) {
                return 0.0;
            }
        }
    }

    public List<String> getStringList(String path) {
        return this.getConfigNode(path).getStringList();
    }

    public List<String> getStringList() {
        String[] lines = this.value.split(" APF_NEWLINE ");
        ArrayList<String> values = new ArrayList<String>();
        for (String line : lines) {
            String trim = line.trim();
            if (trim.isEmpty()) continue;
            if (trim.startsWith("-")) {
                String s = trim.substring(1).trim();
                values.add(this.getStringFrom(s));
                continue;
            }
            if (values.isEmpty()) {
                values.add(trim);
                continue;
            }
            String oldValue = (String)values.get(values.size() - 1);
            values.remove(oldValue);
            values.add(this.getStringFrom(oldValue + trim));
        }
        return values;
    }

    public List<Integer> getIntList(String path) {
        return this.getConfigNode(path).getIntList();
    }

    public List<Integer> getIntList() {
        return this.getStringList().stream().map(this::getInteger).collect(Collectors.toList());
    }

    public ConfigNode getConfigNode(String path) {
        String[] split = path.split("\\.");
        ConfigNode node = this;
        for (String key : split) {
            ConfigNode parent = node;
            node = node.children.get(key);
            if (node != null) continue;
            ConfigNode newN = new ConfigNode(key, parent, "");
            parent.addChild(key, newN);
            node = newN;
        }
        return node;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public void setComment(List<String> comment) {
        this.comment = comment;
    }

    public void set(String path, Object value) {
        String[] split = path.split("\\.");
        ConfigNode node = this.getConfigNode(path);
        node.set(value);
    }

    public void set(Object value) {
        if (value instanceof List) {
            StringBuilder valueBuilder = new StringBuilder();
            for (Object o : (List)value) {
                valueBuilder.append(" APF_NEWLINE - ").append(o.toString());
            }
            this.value = valueBuilder.toString();
        } else {
            String s = value.toString();
            if (s.startsWith("'") && s.endsWith("'")) {
                s = '\"' + s + '\"';
            } else if (s.startsWith("#") || s.startsWith("\"") && s.endsWith("\"")) {
                s = "'" + s + "'";
            }
            this.value = s;
        }
    }

    public void save() throws IOException {
        ConfigNode parent = this.parent;
        while (parent.parent != null) {
            parent = parent.parent;
        }
        parent.save();
    }

    public String getValue() {
        return this.value;
    }

    public void addChild(String name, ConfigNode node) {
        this.children.put(name, node);
        if (!this.childOrder.contains(name)) {
            this.childOrder.add(name);
        }
    }

    public String getKey(boolean deep) {
        if (deep && this.parent != null) {
            String s = this.parent.getKey(true) + "." + this.key;
            if (s.startsWith(".")) {
                return s.substring(1);
            }
            return s;
        }
        return this.key;
    }

    public void sort() {
        Collections.sort(this.childOrder);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.key);
        toString.append(":\n");
        for (String key : this.childOrder) {
            toString.append(this.key).append(".").append(this.children.get(key).toString());
        }
        return toString.toString();
    }

    public boolean contains(String key) {
        String[] split = key.split("\\.", 2);
        ConfigNode child = this.children.get(split[0]);
        if (child == null) {
            return false;
        }
        if (split.length <= 1) {
            return true;
        }
        return child.contains(split[1]);
    }

    public void copyDefaults(ConfigNode config) {
        for (String key : config.childOrder) {
            ConfigNode copyFromNode = config.getConfigNode(key);
            if (!this.contains(key)) {
                this.addChild(key, copyFromNode);
                continue;
            }
            ConfigNode thisNode = this.getConfigNode(key);
            List<String> comment = thisNode.comment;
            List<String> copyComment = copyFromNode.comment;
            if (comment.size() < copyComment.size()) {
                thisNode.comment = copyComment;
            }
            thisNode.copyDefaults(copyFromNode);
        }
    }
}

