/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api;

public enum TimeAmount {
    MILLISECOND(1L),
    SECOND(1000L),
    MINUTE(60L * SECOND.ms()),
    HOUR(60L * MINUTE.ms()),
    DAY(24L * HOUR.ms()),
    WEEK(7L * DAY.ms()),
    MONTH(30L * DAY.ms()),
    YEAR(365L * DAY.ms());

    private final long ms;

    private TimeAmount(long ms) {
        this.ms = ms;
    }

    public long ticks() {
        return this.ms / 1000L * 20L;
    }

    public long ms() {
        return this.ms;
    }

    public long ns() {
        return this.ms * 1000000L;
    }

    public static long ticksToMillis(long ticks) {
        return ticks * 1000L / 20L;
    }

    public static long currentMs() {
        return System.currentTimeMillis();
    }
}

