/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.StaticHolder;
import com.djrapitops.plugin.api.Benchmark;
import com.djrapitops.plugin.api.systems.NotificationCenter;
import com.djrapitops.plugin.api.systems.TaskCenter;
import com.djrapitops.plugin.api.utility.Version;
import com.djrapitops.plugin.api.utility.log.DebugLog;
import com.djrapitops.plugin.command.SubCommand;
import com.djrapitops.plugin.command.bungee.BungeeCommand;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.IOException;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;

public abstract class BungeePlugin
extends Plugin
implements IPlugin {
    protected boolean reloading;

    @Override
    public void onEnable() {
        StaticHolder.register(this);
    }

    @Override
    public void onDisable() {
        Class<?> pluginClass = this.getClass();
        StaticHolder.unRegister(pluginClass);
        Benchmark.pluginDisabled(pluginClass);
        DebugLog.pluginDisabled(pluginClass);
        TaskCenter.cancelAllKnownTasks(pluginClass);
    }

    @Override
    public void reloadPlugin(boolean full) {
        this.reloading = true;
        if (full) {
            this.onDisable();
            this.onReload();
            this.onEnable();
        } else {
            this.onReload();
        }
        this.reloading = false;
    }

    @Override
    public void log(String level, String s) {
        Logger logger = this.getLogger();
        switch (level.toUpperCase()) {
            case "INFO": 
            case "I": {
                logger.info(s);
                break;
            }
            case "INFO_COLOR": {
                this.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent(s));
                break;
            }
            case "W": 
            case "WARN": 
            case "WARNING": {
                logger.warning(s);
                break;
            }
            case "E": 
            case "ERR": 
            case "ERROR": 
            case "SEVERE": {
                logger.severe(s);
                break;
            }
            default: {
                logger.info(s);
            }
        }
    }

    public void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            this.getProxy().getPluginManager().registerListener((Plugin)this, listener);
            StaticHolder.saveInstance(listener.getClass(), this.getClass());
        }
    }

    public void registerCommand(String name, SubCommand command) {
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BungeeCommand(command));
        StaticHolder.saveInstance(command.getClass(), this.getClass());
    }

    protected boolean isNewVersionAvailable(String versionStringUrl) throws IOException {
        return Version.checkVersion(this.getVersion(), versionStringUrl);
    }

    public NotificationCenter getNotificationCenter() {
        return StaticHolder.getNotificationCenter();
    }

    public RunnableFactory getRunnableFactory() {
        return StaticHolder.getRunnableFactory();
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }
}

