/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.StaticHolder;
import com.djrapitops.plugin.api.Benchmark;
import com.djrapitops.plugin.api.systems.NotificationCenter;
import com.djrapitops.plugin.api.systems.TaskCenter;
import com.djrapitops.plugin.api.utility.Version;
import com.djrapitops.plugin.api.utility.log.DebugLog;
import com.djrapitops.plugin.command.SubCommand;
import com.djrapitops.plugin.command.bukkit.BukkitCommand;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BukkitPlugin
extends JavaPlugin
implements IPlugin {
    protected boolean reloading;

    @Override
    public void onEnable() {
        StaticHolder.register(this);
    }

    @Override
    public void onDisable() {
        Class<?> pluginClass = this.getClass();
        Benchmark.pluginDisabled(pluginClass);
        DebugLog.pluginDisabled(pluginClass);
        TaskCenter.cancelAllKnownTasks(pluginClass);
        StaticHolder.unRegister(pluginClass);
    }

    @Override
    public void log(String level, String s) {
        Logger logger = this.getLogger();
        switch (level.toUpperCase()) {
            case "INFO": 
            case "I": {
                logger.info(s);
                break;
            }
            case "INFO_COLOR": {
                this.getServer().getConsoleSender().sendMessage(s);
                break;
            }
            case "W": 
            case "WARN": 
            case "WARNING": {
                logger.warning(s);
                break;
            }
            case "E": 
            case "ERR": 
            case "ERROR": 
            case "SEVERE": {
                logger.severe(s);
                break;
            }
            default: {
                logger.info(s);
            }
        }
    }

    public void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
            StaticHolder.saveInstance(listener.getClass(), this.getClass());
        }
    }

    public void registerCommand(String name, SubCommand command) {
        this.getCommand(name).setExecutor((CommandExecutor)new BukkitCommand(command));
        StaticHolder.saveInstance(command.getClass(), this.getClass());
    }

    protected boolean isNewVersionAvailable(String versionStringUrl) throws IOException {
        return Version.checkVersion(this.getVersion(), versionStringUrl);
    }

    public NotificationCenter getNotificationCenter() {
        return StaticHolder.getNotificationCenter();
    }

    public RunnableFactory getRunnableFactory() {
        return StaticHolder.getRunnableFactory();
    }

    @Override
    public void reloadPlugin(boolean full) {
        this.reloading = true;
        if (full) {
            this.onDisable();
            this.onReload();
            this.onEnable();
        } else {
            this.onReload();
        }
        this.reloading = false;
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }
}

