package com.djrapitops.plugin.utilities;

import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.StaticHolder;

/**
 * Class for getting information about the current StackTrace.
 *
 * @author Rsl1122
 */
public class StackUtils {

    /**
     * Get the calling Plugin class from the StackTrace.
     *
     * @return Class that extends Plugin or Plugin.class if not found in the
     * StackTrace.
     */
    public static Class getCallingPlugin() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (StackTraceElement element : stack) {
            Class c;
            try {
                c = Class.forName(element.getClassName());
            } catch (ClassNotFoundException e) {
                continue;
            }
            if (IPlugin.class.isAssignableFrom(c)) {
                return c;
            }
        }
        for (StackTraceElement element : stack) {
            Class c;
            try {
                c = Class.forName(element.getClassName());
            } catch (ClassNotFoundException e) {
                continue;
            }
            Class provider = StaticHolder.getProvidingPlugin(c);
            if (provider != null) {
                return provider;
            }
        }
        return IPlugin.class;
    }
}
