/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AES {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String CIPHER = "AES/CBC/PKCS5Padding";
    private static final int IV_LENGTH = 16;

    public static SecretKey getSecretKey(String keyFile) throws IOException {
        byte[] keyb = Files.readAllBytes(Paths.get(keyFile, new String[0]));
        return new SecretKeySpec(keyb, "AES");
    }

    public static byte[] encrypt(byte[] plainBytes, SecretKey secretKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] iv = new byte[16];
        RANDOM.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher ci = Cipher.getInstance(CIPHER);
        ci.init(1, (Key)secretKey, ivSpec);
        return AES.combine(iv, ci.doFinal(plainBytes));
    }

    private static byte[] combine(byte[] first, byte[] second) {
        byte[] combined = new byte[first.length + second.length];
        System.arraycopy(first, 0, combined, 0, first.length);
        System.arraycopy(second, 0, combined, first.length, second.length);
        return combined;
    }

    public static byte[] decrypt(byte[] cipherBytes, SecretKey secretKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] iv = new byte[16];
        byte[] rest = new byte[cipherBytes.length - 16];
        System.arraycopy(cipherBytes, 0, iv, 0, iv.length);
        System.arraycopy(cipherBytes, 16, rest, 0, rest.length);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher ci = Cipher.getInstance(CIPHER);
        ci.init(2, (Key)secretKey, ivSpec);
        return ci.doFinal(rest);
    }
}

