/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.util;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class MappingIterable<I, O>
implements Iterable<O> {
    private final Function<I, O> mapper;
    private final Iterable<I> original;

    public MappingIterable(Function<I, O> mapper, Iterable<I> original) {
        this.mapper = mapper;
        this.original = original;
    }

    @Override
    public void forEach(Consumer<? super O> action) {
        this.original.forEach((? super T it) -> {
            O mapped = this.mapper.apply(it);
            action.accept((O)mapped);
        });
    }

    @Override
    public Spliterator<O> spliterator() {
        return new MappingSpliterator(this.original.spliterator());
    }

    @Override
    public Iterator<O> iterator() {
        return new MappingIterator(this.original.iterator());
    }

    private class MappingSpliterator
    implements Spliterator<O> {
        private final Spliterator<I> original;

        private MappingSpliterator(Spliterator<I> original) {
            this.original = original;
        }

        @Override
        public boolean tryAdvance(Consumer<? super O> action) {
            return this.original.tryAdvance((? super T it) -> {
                Object mapped = MappingIterable.this.mapper.apply(it);
                action.accept((Object)mapped);
            });
        }

        @Override
        public void forEachRemaining(Consumer<? super O> action) {
            this.original.forEachRemaining((? super T it) -> {
                Object mapped = MappingIterable.this.mapper.apply(it);
                action.accept((Object)mapped);
            });
        }

        @Override
        public Spliterator<O> trySplit() {
            return new MappingSpliterator(this.original.trySplit());
        }

        @Override
        public long estimateSize() {
            return this.original.estimateSize();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.original.getExactSizeIfKnown();
        }

        @Override
        public int characteristics() {
            return this.original.characteristics();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return this.original.hasCharacteristics(characteristics);
        }
    }

    private class MappingIterator
    implements Iterator<O> {
        private final Iterator<I> original;

        private MappingIterator(Iterator<I> original) {
            this.original = original;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public O next() {
            return MappingIterable.this.mapper.apply(this.original.next());
        }

        @Override
        public void remove() {
            this.original.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super O> action) {
            this.original.forEachRemaining((? super E it) -> {
                Object mapped = MappingIterable.this.mapper.apply(it);
                action.accept((Object)mapped);
            });
        }
    }
}

