/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.service;

import discord4j.store.api.Store;
import discord4j.store.api.noop.NoOpStoreService;
import discord4j.store.api.primitive.ForwardingStoreService;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.Lazy;
import discord4j.store.api.util.StoreContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import reactor.core.publisher.Mono;

public class StoreServiceLoader {
    private final Lazy<StoreService> generalService = new Lazy<StoreService>(() -> {
        ArrayList<StoreService> services = new ArrayList<StoreService>();
        ServiceLoader<StoreService> serviceLoader = ServiceLoader.load(StoreService.class);
        serviceLoader.iterator().forEachRemaining(services::add);
        services.add(new NoOpStoreService());
        services.sort(new Comparator<StoreService>(){

            @Override
            public int compare(StoreService ss1, StoreService ss2) {
                return Integer.compare(priorityOverrides.getOrDefault(ss1.getClass(), ss1.order()), priorityOverrides.getOrDefault(ss2.getClass(), ss2.order()));
            }
        });
        StoreService generic = services.stream().filter(StoreService::hasGenericStores).findFirst().get();
        StoreService primitive = services.stream().filter(StoreService::hasLongObjStores).findFirst().get();
        if (primitive instanceof NoOpStoreService && !(generic instanceof NoOpStoreService)) {
            return new ForwardingStoreService(generic);
        }
        return generic == primitive ? generic : new ComposedStoreService(generic, primitive);
    });

    public StoreServiceLoader() {
        this(Collections.emptyMap());
    }

    public StoreServiceLoader(final Map<Class<? extends StoreService>, Integer> priorityOverrides) {
    }

    public StoreService getStoreService() {
        return this.generalService.get();
    }

    public <K extends Comparable<K>, V extends Serializable> Store<K, V> newGenericStore(Class<K> keyClass, Class<V> valueClass) {
        return this.getStoreService().provideGenericStore(keyClass, valueClass);
    }

    public <V extends Serializable> LongObjStore<V> newLongObjStore(Class<V> valueClass) {
        return this.getStoreService().provideLongObjStore(valueClass);
    }

    private static final class ComposedStoreService
    implements StoreService {
        private final StoreService genericService;
        private final StoreService primitiveService;

        private ComposedStoreService(StoreService genericService, StoreService primitiveService) {
            this.genericService = genericService;
            this.primitiveService = primitiveService;
        }

        @Override
        public int order() {
            int p2;
            int p1 = this.genericService.order();
            return p1 > (p2 = this.primitiveService.order()) ? p1 : p2;
        }

        @Override
        public boolean hasGenericStores() {
            return this.genericService.hasGenericStores();
        }

        @Override
        public <K extends Comparable<K>, V extends Serializable> Store<K, V> provideGenericStore(Class<K> keyClass, Class<V> valueClass) {
            return this.genericService.provideGenericStore(keyClass, valueClass);
        }

        @Override
        public boolean hasLongObjStores() {
            return this.primitiveService.hasLongObjStores();
        }

        @Override
        public <V extends Serializable> LongObjStore<V> provideLongObjStore(Class<V> valueClass) {
            return this.primitiveService.provideLongObjStore(valueClass);
        }

        @Override
        public Mono<Void> init(StoreContext context) {
            return this.genericService.init(context).and(this.primitiveService.init(context));
        }

        @Override
        public Mono<Void> dispose() {
            return this.genericService.dispose().and(this.primitiveService.dispose());
        }
    }
}

