/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.primitive;

import discord4j.store.api.Store;
import discord4j.store.api.primitive.ForwardingStore;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.StoreContext;
import java.io.Serializable;
import reactor.core.publisher.Mono;

public class ForwardingStoreService
implements StoreService {
    private final StoreService toForward;

    public ForwardingStoreService(StoreService toForward) {
        this.toForward = toForward;
    }

    public StoreService getOriginal() {
        return this.toForward;
    }

    @Override
    public int order() {
        return this.toForward.order();
    }

    @Override
    public boolean hasGenericStores() {
        return this.getOriginal().hasGenericStores();
    }

    @Override
    public <K extends Comparable<K>, V extends Serializable> Store<K, V> provideGenericStore(Class<K> keyClass, Class<V> valueClass) {
        return this.getOriginal().provideGenericStore(keyClass, valueClass);
    }

    @Override
    public boolean hasLongObjStores() {
        return true;
    }

    @Override
    public <V extends Serializable> LongObjStore<V> provideLongObjStore(Class<V> valueClass) {
        return new ForwardingStore<V>(this.getOriginal().provideGenericStore(Long.class, valueClass));
    }

    @Override
    public Mono<Void> init(StoreContext context) {
        return this.toForward.init(context);
    }

    @Override
    public Mono<Void> dispose() {
        return this.toForward.dispose();
    }
}

