/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.primitive;

import discord4j.store.api.Store;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.util.LongObjTuple2;
import java.io.Serializable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ForwardingStore<V extends Serializable>
implements LongObjStore<V> {
    private final Store<Long, V> toForward;

    public ForwardingStore(Store<Long, V> toForward) {
        this.toForward = toForward;
    }

    protected Store<Long, V> getOriginal() {
        return this.toForward;
    }

    @Override
    public Mono<Void> save(Long key, V value) {
        return this.toForward.save(key, value);
    }

    @Override
    public Mono<Void> saveWithLong(long key, V value) {
        return this.save(key, value);
    }

    @Override
    public Mono<Void> save(Publisher<Tuple2<Long, V>> entryStream) {
        return this.toForward.save(entryStream);
    }

    @Override
    public Mono<Void> saveWithLong(Publisher<LongObjTuple2<V>> entryStream) {
        return this.save((Publisher<Tuple2<Long, V>>)Flux.from(entryStream).map(LongObjTuple2::convert));
    }

    @Override
    public Mono<V> find(Long id) {
        return this.toForward.find(id);
    }

    @Override
    public Mono<V> find(long id) {
        return this.find((Long)id);
    }

    @Override
    public Flux<V> findInRange(Long start, Long end) {
        return this.toForward.findInRange(start, end);
    }

    @Override
    public Flux<V> findInRange(long start, long end) {
        return this.findInRange((Long)start, (Long)end);
    }

    @Override
    public Mono<Long> count() {
        return this.toForward.count();
    }

    @Override
    public Mono<Void> delete(Long id) {
        return this.toForward.delete(id);
    }

    @Override
    public Mono<Void> delete(long id) {
        return this.delete((Long)id);
    }

    @Override
    public Mono<Void> delete(Publisher<Long> ids) {
        return this.toForward.delete(ids);
    }

    @Override
    public Mono<Void> deleteInRange(Long start, Long end) {
        return this.toForward.deleteInRange(start, end);
    }

    @Override
    public Mono<Void> deleteInRange(long start, long end) {
        return this.deleteInRange((Long)start, (Long)end);
    }

    @Override
    public Mono<Void> deleteAll() {
        return this.toForward.deleteAll();
    }

    @Override
    public Flux<Long> keys() {
        return this.toForward.keys();
    }

    @Override
    public Flux<V> values() {
        return this.toForward.values();
    }

    @Override
    public Flux<Tuple2<Long, V>> entries() {
        return this.toForward.entries();
    }

    @Override
    public Mono<Void> invalidate() {
        return this.toForward.invalidate();
    }

    @Override
    public Flux<LongObjTuple2<V>> longObjEntries() {
        return this.entries().map(LongObjTuple2::from);
    }

    public String toString() {
        return "ForwardingStore{forwardingTo=" + this.toForward + '}';
    }
}

