/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api;

import java.io.Serializable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public interface Store<K extends Comparable<K>, V extends Serializable> {
    public Mono<Void> save(K var1, V var2);

    public Mono<Void> save(Publisher<Tuple2<K, V>> var1);

    public Mono<V> find(K var1);

    public Flux<V> findInRange(K var1, K var2);

    public Mono<Long> count();

    public Mono<Void> delete(K var1);

    public Mono<Void> delete(Publisher<K> var1);

    public Mono<Void> deleteInRange(K var1, K var2);

    public Mono<Void> deleteAll();

    public Flux<K> keys();

    public Flux<V> values();

    default public Flux<Tuple2<K, V>> entries() {
        return this.keys().zipWith(this.values());
    }

    public Mono<Void> invalidate();
}

