/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.response;

import discord4j.common.annotations.Experimental;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.request.RouteMatcher;
import discord4j.rest.response.ResponseFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Experimental
public class RetryingTransformer
implements ResponseFunction {
    private final RouteMatcher routeMatcher;
    private final Retry retryStrategy;

    public RetryingTransformer(RouteMatcher routeMatcher, Retry retryStrategy) {
        this.routeMatcher = routeMatcher;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public Function<Mono<ClientResponse>, Mono<ClientResponse>> transform(DiscordWebRequest request) {
        if (this.routeMatcher.matches(request)) {
            return mono -> mono.retryWhen(this.retryStrategy);
        }
        return mono -> mono;
    }
}

