/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.GuildStickerModifyRequest;
import discord4j.discordjson.json.StickerData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestGuild;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestSticker {
    private final RestClient restClient;
    private final long guildId;
    private final long id;

    private RestSticker(RestClient restClient, long guildId, long id) {
        this.restClient = restClient;
        this.guildId = guildId;
        this.id = id;
    }

    public static RestSticker create(RestClient restClient, Snowflake guildId, Snowflake id) {
        return new RestSticker(restClient, guildId.asLong(), id.asLong());
    }

    static RestSticker create(RestClient restClient, long guildId, long id) {
        return new RestSticker(restClient, guildId, id);
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Snowflake getId() {
        return Snowflake.of((long)this.id);
    }

    public RestGuild guild() {
        return RestGuild.create(this.restClient, this.guildId);
    }

    public Mono<StickerData> getData() {
        return this.restClient.getStickerService().getGuildSticker(this.guildId, this.id);
    }

    public Mono<StickerData> modify(GuildStickerModifyRequest request, @Nullable String reason) {
        return this.restClient.getStickerService().modifyGuildSticker(this.guildId, this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getStickerService().deleteGuildSticker(this.guildId, this.id, reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestSticker restSticker = (RestSticker)o;
        return this.guildId == restSticker.guildId && this.id == restSticker.id;
    }

    public int hashCode() {
        return Objects.hash(this.guildId, this.id);
    }
}

