/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest;

import discord4j.common.JacksonResources;
import discord4j.common.ReactorResources;
import discord4j.rest.RestClient;
import discord4j.rest.RestResources;
import discord4j.rest.http.ExchangeStrategies;
import discord4j.rest.http.client.AuthorizationScheme;
import discord4j.rest.request.BucketGlobalRateLimiter;
import discord4j.rest.request.DefaultRouter;
import discord4j.rest.request.GlobalRateLimiter;
import discord4j.rest.request.RequestQueueFactory;
import discord4j.rest.request.Router;
import discord4j.rest.request.RouterOptions;
import discord4j.rest.response.ResponseFunction;
import discord4j.rest.util.AllowedMentions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public class RestClientBuilder<C, O extends RouterOptions> {
    protected final Function<Config, C> clientFactory;
    protected final Function<RouterOptions, O> optionsModifier;
    protected String token;
    protected ReactorResources reactorResources;
    protected JacksonResources jacksonResources;
    protected ExchangeStrategies exchangeStrategies;
    protected List<ResponseFunction> responseTransformers = new ArrayList<ResponseFunction>();
    protected GlobalRateLimiter globalRateLimiter;
    protected RequestQueueFactory requestQueueFactory;
    @Nullable
    protected AllowedMentions allowedMentions;

    public static RestClientBuilder<RestClient, RouterOptions> createRest(String token) {
        Function<Config, RestClient> clientFactory = config -> {
            RestResources restResources = new RestResources(config.getToken(), config.getReactorResources(), config.getJacksonResources(), config.getRouter(), config.getAllowedMentions().orElse(null));
            return new RestClient(restResources);
        };
        return new RestClientBuilder<RestClient, RouterOptions>(token, clientFactory, Function.identity());
    }

    public static RestClientBuilder<RestClient, RouterOptions> createRestApplication() {
        Function<Config, RestClient> clientFactory = config -> {
            RestResources restResources = new RestResources(AuthorizationScheme.NONE, "", config.getReactorResources(), config.getJacksonResources(), config.getRouter(), config.getAllowedMentions().orElse(null));
            return new RestClient(restResources);
        };
        return new RestClientBuilder<RestClient, RouterOptions>("", clientFactory, Function.identity());
    }

    protected RestClientBuilder(String token, Function<Config, C> clientFactory, Function<RouterOptions, O> optionsModifier) {
        this.token = Objects.requireNonNull(token, "token");
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        this.optionsModifier = Objects.requireNonNull(optionsModifier, "optionsModifier");
    }

    protected RestClientBuilder(RestClientBuilder<?, ?> source, Function<Config, C> clientFactory, Function<RouterOptions, O> optionsModifier) {
        this.clientFactory = clientFactory;
        this.optionsModifier = optionsModifier;
        this.token = source.token;
        this.reactorResources = source.reactorResources;
        this.jacksonResources = source.jacksonResources;
        this.exchangeStrategies = source.exchangeStrategies;
        this.responseTransformers = source.responseTransformers;
        this.globalRateLimiter = source.globalRateLimiter;
        this.requestQueueFactory = source.requestQueueFactory;
    }

    public <O2 extends RouterOptions> RestClientBuilder<C, O2> setExtraOptions(Function<? super O, O2> optionsModifier) {
        return new RestClientBuilder<C, O2>(this, this.clientFactory, this.optionsModifier.andThen(optionsModifier));
    }

    public RestClientBuilder<C, O> setToken(String token) {
        this.token = Objects.requireNonNull(token, "token");
        return this;
    }

    public RestClientBuilder<C, O> setReactorResources(ReactorResources reactorResources) {
        this.reactorResources = reactorResources;
        return this;
    }

    public RestClientBuilder<C, O> setJacksonResources(JacksonResources jacksonResources) {
        this.jacksonResources = jacksonResources;
        return this;
    }

    public RestClientBuilder<C, O> setExchangeStrategies(ExchangeStrategies exchangeStrategies) {
        this.exchangeStrategies = Objects.requireNonNull(exchangeStrategies, "exchangeStrategies");
        return this;
    }

    public RestClientBuilder<C, O> onClientResponse(ResponseFunction responseFunction) {
        this.responseTransformers.add(responseFunction);
        return this;
    }

    public RestClientBuilder<C, O> setGlobalRateLimiter(GlobalRateLimiter globalRateLimiter) {
        this.globalRateLimiter = globalRateLimiter;
        return this;
    }

    public RestClientBuilder<C, O> setRequestQueueFactory(RequestQueueFactory requestQueueFactory) {
        this.requestQueueFactory = requestQueueFactory;
        return this;
    }

    public RestClientBuilder<C, O> setDefaultAllowedMentions(AllowedMentions allowedMentions) {
        this.allowedMentions = allowedMentions;
        return this;
    }

    public C build() {
        return this.build(DefaultRouter::new);
    }

    public C build(Function<O, Router> routerFactory) {
        ReactorResources reactor = this.initReactorResources();
        JacksonResources jackson = this.initJacksonResources();
        O options = this.buildOptions(reactor, jackson);
        Router router = routerFactory.apply(options);
        Config config = new Config(this.token, reactor, jackson, this.initExchangeStrategies(jackson), Collections.unmodifiableList(this.responseTransformers), this.globalRateLimiter, router, this.allowedMentions);
        return this.clientFactory.apply(config);
    }

    private O buildOptions(ReactorResources reactor, JacksonResources jackson) {
        RouterOptions options = new RouterOptions(this.token, reactor, this.initExchangeStrategies(jackson), this.responseTransformers, this.initGlobalRateLimiter(reactor), this.initRequestQueueFactory(), "https://discord.com/api/v9");
        return (O)((RouterOptions)this.optionsModifier.apply(options));
    }

    private ReactorResources initReactorResources() {
        if (this.reactorResources != null) {
            return this.reactorResources;
        }
        return new ReactorResources();
    }

    private JacksonResources initJacksonResources() {
        if (this.jacksonResources != null) {
            return this.jacksonResources;
        }
        return JacksonResources.create();
    }

    private ExchangeStrategies initExchangeStrategies(JacksonResources jacksonResources) {
        if (this.exchangeStrategies != null) {
            return this.exchangeStrategies;
        }
        return ExchangeStrategies.jackson(jacksonResources.getObjectMapper());
    }

    private GlobalRateLimiter initGlobalRateLimiter(ReactorResources reactorResources) {
        if (this.globalRateLimiter != null) {
            return this.globalRateLimiter;
        }
        return BucketGlobalRateLimiter.create(50, Duration.ofSeconds(1L), reactorResources.getTimerTaskScheduler());
    }

    private RequestQueueFactory initRequestQueueFactory() {
        if (this.requestQueueFactory != null) {
            return this.requestQueueFactory;
        }
        return RequestQueueFactory.buffering();
    }

    protected static class Config {
        private final String token;
        private final ReactorResources reactorResources;
        private final JacksonResources jacksonResources;
        private final ExchangeStrategies exchangeStrategies;
        private final List<ResponseFunction> responseTransformers;
        private final GlobalRateLimiter globalRateLimiter;
        private final Router router;
        private final AllowedMentions allowedMentions;

        public Config(String token, ReactorResources reactorResources, JacksonResources jacksonResources, ExchangeStrategies exchangeStrategies, List<ResponseFunction> responseTransformers, GlobalRateLimiter globalRateLimiter, Router router, @Nullable AllowedMentions allowedMentions) {
            this.token = token;
            this.reactorResources = reactorResources;
            this.jacksonResources = jacksonResources;
            this.exchangeStrategies = exchangeStrategies;
            this.responseTransformers = responseTransformers;
            this.globalRateLimiter = globalRateLimiter;
            this.router = router;
            this.allowedMentions = allowedMentions;
        }

        public String getToken() {
            return this.token;
        }

        public ReactorResources getReactorResources() {
            return this.reactorResources;
        }

        public JacksonResources getJacksonResources() {
            return this.jacksonResources;
        }

        public ExchangeStrategies getExchangeStrategies() {
            return this.exchangeStrategies;
        }

        public List<ResponseFunction> getResponseTransformers() {
            return this.responseTransformers;
        }

        public GlobalRateLimiter getGlobalRateLimiter() {
            return this.globalRateLimiter;
        }

        public Router getRouter() {
            return this.router;
        }

        public Optional<AllowedMentions> getAllowedMentions() {
            return Optional.ofNullable(this.allowedMentions);
        }
    }
}

