/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import discord4j.discordjson.json.MessageCreateRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MultipartRequest<T> {
    private final T jsonPayload;
    private final List<Tuple2<String, InputStream>> files;

    private MultipartRequest(T jsonPayload, List<Tuple2<String, InputStream>> files) {
        this.jsonPayload = jsonPayload;
        this.files = Collections.unmodifiableList(files);
    }

    public static <T> MultipartRequest<T> ofRequest(T body) {
        return new MultipartRequest<T>(body, Collections.emptyList());
    }

    public static <T> MultipartRequest<T> ofRequestAndFiles(T body, List<Tuple2<String, InputStream>> files) {
        return new MultipartRequest<T>(body, files);
    }

    public <R> MultipartRequest<R> withRequest(R body) {
        return new MultipartRequest<R>(body, this.files);
    }

    public MultipartRequest<T> addFile(String fileName, InputStream file) {
        ArrayList<Tuple2<String, InputStream>> list = new ArrayList<Tuple2<String, InputStream>>(this.files);
        list.add((Tuple2<String, InputStream>)Tuples.of((Object)fileName, (Object)file));
        return new MultipartRequest<T>(this.jsonPayload, Collections.unmodifiableList(list));
    }

    public MultipartRequest<T> addFiles(List<Tuple2<String, InputStream>> filesList) {
        ArrayList<Tuple2<String, InputStream>> list = new ArrayList<Tuple2<String, InputStream>>(this.files);
        list.addAll(filesList);
        return new MultipartRequest<T>(this.jsonPayload, Collections.unmodifiableList(list));
    }

    @Deprecated
    @Nullable
    public MessageCreateRequest getCreateRequest() {
        return (MessageCreateRequest)this.jsonPayload;
    }

    public T getJsonPayload() {
        return this.jsonPayload;
    }

    public List<Tuple2<String, InputStream>> getFiles() {
        return this.files;
    }
}

