/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.ApplicationCommandData;
import discord4j.discordjson.json.ApplicationCommandPermissionsRequest;
import discord4j.discordjson.json.ApplicationCommandRequest;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.GuildApplicationCommandPermissionsData;
import discord4j.discordjson.json.PartialGuildApplicationCommandPermissionsData;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ApplicationService
extends RestService {
    public ApplicationService(Router router) {
        super(router);
    }

    public Mono<ApplicationInfoData> getCurrentApplicationInfo() {
        return Routes.APPLICATION_INFO_GET.newRequest(new Object[0]).exchange(this.getRouter()).bodyToMono(ApplicationInfoData.class);
    }

    public Flux<ApplicationCommandData> getGlobalApplicationCommands(long applicationId) {
        return Routes.GLOBAL_APPLICATION_COMMANDS_GET.newRequest(applicationId).exchange(this.getRouter()).bodyToMono(ApplicationCommandData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<ApplicationCommandData> createGlobalApplicationCommand(long applicationId, ApplicationCommandRequest request) {
        return Routes.GLOBAL_APPLICATION_COMMANDS_CREATE.newRequest(applicationId).body(request).exchange(this.getRouter()).bodyToMono(ApplicationCommandData.class);
    }

    public Flux<ApplicationCommandData> bulkOverwriteGlobalApplicationCommand(long applicationId, List<ApplicationCommandRequest> requests) {
        return Routes.GLOBAL_APPLICATION_COMMANDS_BULK_OVERWRITE.newRequest(applicationId).body(requests).exchange(this.getRouter()).bodyToMono(ApplicationCommandData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<ApplicationCommandData> getGlobalApplicationCommand(long applicationId, long commandId) {
        return Routes.GLOBAL_APPLICATION_COMMAND_GET.newRequest(applicationId, commandId).exchange(this.getRouter()).bodyToMono(ApplicationCommandData.class);
    }

    public Mono<ApplicationCommandData> modifyGlobalApplicationCommand(long applicationId, long commandId, ApplicationCommandRequest request) {
        return Routes.GLOBAL_APPLICATION_COMMAND_MODIFY.newRequest(applicationId, commandId).body(request).exchange(this.getRouter()).bodyToMono(ApplicationCommandData.class);
    }

    public Mono<Void> deleteGlobalApplicationCommand(long applicationId, long commandId) {
        return Routes.GLOBAL_APPLICATION_COMMAND_DELETE.newRequest(applicationId, commandId).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Flux<ApplicationCommandData> getGuildApplicationCommands(long applicationId, long guildId) {
        return Routes.GUILD_APPLICATION_COMMANDS_GET.newRequest(applicationId, guildId).exchange(this.getRouter()).bodyToMono(ApplicationCommandData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<ApplicationCommandData> createGuildApplicationCommand(long applicationId, long guildId, ApplicationCommandRequest request) {
        return Routes.GUILD_APPLICATION_COMMANDS_CREATE.newRequest(applicationId, guildId).body(request).exchange(this.getRouter()).bodyToMono(ApplicationCommandData.class);
    }

    public Flux<ApplicationCommandData> bulkOverwriteGuildApplicationCommand(long applicationId, long guildId, List<ApplicationCommandRequest> requests) {
        return Routes.GUILD_APPLICATION_COMMANDS_BULK_OVERWRITE.newRequest(applicationId, guildId).body(requests).exchange(this.getRouter()).bodyToMono(ApplicationCommandData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<ApplicationCommandData> getGuildApplicationCommand(long applicationId, long guildId, long commandId) {
        return Routes.GUILD_APPLICATION_COMMAND_GET.newRequest(applicationId, guildId, commandId).exchange(this.getRouter()).bodyToMono(ApplicationCommandData.class);
    }

    public Mono<ApplicationCommandData> modifyGuildApplicationCommand(long applicationId, long guildId, long commandId, ApplicationCommandRequest request) {
        return Routes.GUILD_APPLICATION_COMMAND_MODIFY.newRequest(applicationId, guildId, commandId).body(request).exchange(this.getRouter()).bodyToMono(ApplicationCommandData.class);
    }

    public Mono<Void> deleteGuildApplicationCommand(long applicationId, long guildId, long commandId) {
        return Routes.GUILD_APPLICATION_COMMAND_DELETE.newRequest(applicationId, guildId, commandId).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Flux<GuildApplicationCommandPermissionsData> getGuildApplicationCommandPermissions(long applicationId, long guildId) {
        return Routes.GUILD_APPLICATION_COMMAND_PERMISSIONS_GET.newRequest(applicationId, guildId).exchange(this.getRouter()).bodyToMono(GuildApplicationCommandPermissionsData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<GuildApplicationCommandPermissionsData> getApplicationCommandPermissions(long applicationId, long guildId, long commandId) {
        return Routes.APPLICATION_COMMAND_PERMISSIONS_GET.newRequest(applicationId, guildId, commandId).exchange(this.getRouter()).bodyToMono(GuildApplicationCommandPermissionsData.class);
    }

    public Mono<GuildApplicationCommandPermissionsData> modifyApplicationCommandPermissions(long applicationId, long guildId, long commandId, ApplicationCommandPermissionsRequest request) {
        return Routes.APPLICATION_COMMAND_PERMISSIONS_MODIFY.newRequest(applicationId, guildId, commandId).body(request).exchange(this.getRouter()).bodyToMono(GuildApplicationCommandPermissionsData.class);
    }

    public Flux<GuildApplicationCommandPermissionsData> bulkModifyApplicationCommandPermissions(long applicationId, long guildId, List<PartialGuildApplicationCommandPermissionsData> permissions) {
        return Routes.APPLICATION_COMMAND_PERMISSIONS_BULK_MODIFY.newRequest(applicationId, guildId).body(permissions).exchange(this.getRouter()).bodyToMono(GuildApplicationCommandPermissionsData[].class).flatMapMany(Flux::fromArray);
    }
}

