/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.http.client.AuthorizationScheme;
import discord4j.rest.request.DiscordWebResponse;
import discord4j.rest.request.Router;
import discord4j.rest.route.Route;
import discord4j.rest.util.Multimap;
import discord4j.rest.util.RouteUtils;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import reactor.util.annotation.Nullable;

public class DiscordWebRequest {
    private final Route route;
    private final String completeUri;
    private final Map<String, String> uriVariableMap;
    @Nullable
    private Object body;
    @Nullable
    private Multimap<String, Object> queryParams;
    @Nullable
    private Map<String, Set<String>> headers;
    @Nullable
    private AuthorizationScheme authorizationScheme;
    @Nullable
    private String authorizationValue;

    public DiscordWebRequest(Route route, Object ... uriVars) {
        this.route = route;
        this.completeUri = RouteUtils.expand(route.getUriTemplate(), uriVars);
        this.uriVariableMap = RouteUtils.createVariableMap(route.getUriTemplate(), uriVars);
    }

    DiscordWebRequest(DiscordWebRequest other) {
        this.route = other.route;
        this.completeUri = other.completeUri;
        this.uriVariableMap = other.uriVariableMap;
        this.body = other.body;
        this.queryParams = other.queryParams;
        this.headers = other.headers;
        this.authorizationScheme = other.authorizationScheme;
        this.authorizationValue = other.authorizationValue;
    }

    public DiscordWebRequest copy() {
        return new DiscordWebRequest(this);
    }

    public Route getRoute() {
        return this.route;
    }

    public String getCompleteUri() {
        return this.completeUri;
    }

    @Nullable
    public Object getBody() {
        return this.body;
    }

    @Nullable
    public Multimap<String, Object> getQueryParams() {
        return this.queryParams;
    }

    @Nullable
    public Map<String, Set<String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public AuthorizationScheme getAuthorizationScheme() {
        return this.authorizationScheme;
    }

    @Nullable
    public String getAuthorizationValue() {
        return this.authorizationValue;
    }

    public DiscordWebRequest body(Object body) {
        this.body = body;
        return this;
    }

    public DiscordWebRequest query(String key, Object value) {
        if (this.queryParams == null) {
            this.queryParams = new Multimap();
        }
        this.queryParams.add(key, value);
        return this;
    }

    public DiscordWebRequest query(Map<String, Object> params) {
        params.forEach(this::query);
        return this;
    }

    public DiscordWebRequest query(Multimap<String, Object> params) {
        params.forEachElement(this::query);
        return this;
    }

    public DiscordWebRequest header(String key, String value) {
        this.initHeaders().computeIfAbsent(key.toLowerCase(), k -> new LinkedHashSet()).add(value);
        return this;
    }

    public DiscordWebRequest optionalHeader(String key, @Nullable String value) {
        return value == null ? this : this.header(key, value);
    }

    public DiscordWebRequest bearerAuth(String accessToken) {
        this.authorizationScheme = AuthorizationScheme.BEARER;
        this.authorizationValue = accessToken;
        return this;
    }

    public DiscordWebRequest basicAuth(String base64EncodedValue) {
        this.authorizationScheme = AuthorizationScheme.BASIC;
        this.authorizationValue = base64EncodedValue;
        return this;
    }

    public DiscordWebRequest unauthenticated() {
        this.authorizationScheme = AuthorizationScheme.NONE;
        this.authorizationValue = null;
        return this;
    }

    private Map<String, Set<String>> initHeaders() {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Set<String>>();
        }
        return this.headers;
    }

    boolean matchesVariables(Predicate<Map<String, String>> matcher) {
        return matcher.test(this.uriVariableMap);
    }

    public DiscordWebResponse exchange(Router router) {
        return router.exchange(this);
    }

    public String getDescription() {
        return this.route.getMethod() + " " + this.completeUri;
    }

    public String toString() {
        return "DiscordRequest{route=" + this.route + ", completeUri='" + this.completeUri + '\'' + ", body=" + this.body + ", queryParams=" + this.queryParams + ", headers=" + this.headers + '}';
    }
}

