/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest;

import discord4j.common.JacksonResources;
import discord4j.common.ReactorResources;
import discord4j.common.util.Snowflake;
import discord4j.common.util.TokenUtil;
import discord4j.rest.http.client.AuthorizationScheme;
import discord4j.rest.request.Router;
import discord4j.rest.util.AllowedMentions;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class RestResources {
    private final AuthorizationScheme scheme;
    private final String token;
    private final ReactorResources reactorResources;
    private final JacksonResources jacksonResources;
    private final Router router;
    @Nullable
    private final Long selfId;
    @Nullable
    private final AllowedMentions allowedMentions;

    public RestResources(String token, ReactorResources reactorResources, JacksonResources jacksonResources, Router router, @Nullable AllowedMentions allowedMentions) {
        this(AuthorizationScheme.BOT, token, reactorResources, jacksonResources, router, allowedMentions);
    }

    public RestResources(AuthorizationScheme scheme, String token, ReactorResources reactorResources, JacksonResources jacksonResources, Router router, @Nullable AllowedMentions allowedMentions) {
        this.scheme = scheme;
        this.token = token;
        this.reactorResources = reactorResources;
        this.jacksonResources = jacksonResources;
        this.router = router;
        this.selfId = scheme == AuthorizationScheme.BOT ? Long.valueOf(TokenUtil.getSelfId((String)token)) : null;
        this.allowedMentions = allowedMentions;
    }

    public AuthorizationScheme getScheme() {
        return this.scheme;
    }

    public String getToken() {
        return this.token;
    }

    public ReactorResources getReactorResources() {
        return this.reactorResources;
    }

    public JacksonResources getJacksonResources() {
        return this.jacksonResources;
    }

    public Router getRouter() {
        return this.router;
    }

    public Snowflake getSelfId() {
        return Snowflake.of((long)Optional.ofNullable(this.selfId).orElseThrow(UnsupportedOperationException::new));
    }

    public Optional<AllowedMentions> getAllowedMentions() {
        return Optional.ofNullable(this.allowedMentions);
    }
}

