/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ConnectionData;
import discord4j.discordjson.json.DMCreateRequest;
import discord4j.discordjson.json.GroupDMCreateRequest;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.UserGuildData;
import discord4j.discordjson.json.UserModifyRequest;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserService
extends RestService {
    public UserService(Router router) {
        super(router);
    }

    public Mono<UserData> getCurrentUser() {
        return Routes.CURRENT_USER_GET.newRequest(new Object[0]).exchange(this.getRouter()).bodyToMono(UserData.class);
    }

    public Mono<UserData> getUser(long userId) {
        return Routes.USER_GET.newRequest(userId).exchange(this.getRouter()).bodyToMono(UserData.class);
    }

    public Mono<UserData> modifyCurrentUser(UserModifyRequest request) {
        return Routes.CURRENT_USER_MODIFY.newRequest(new Object[0]).body(request).exchange(this.getRouter()).bodyToMono(UserData.class);
    }

    public Flux<UserGuildData> getCurrentUserGuilds(Map<String, Object> queryParams) {
        return Routes.CURRENT_USER_GUILDS_GET.newRequest(new Object[0]).query(queryParams).exchange(this.getRouter()).bodyToMono(UserGuildData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<Void> leaveGuild(long guildId) {
        return Routes.GUILD_LEAVE.newRequest(guildId).header("content-type", "").exchange(this.getRouter()).bodyToMono(Void.class);
    }

    @Deprecated
    public Flux<ChannelData> getUserDMs() {
        return Routes.USER_DMS_GET.newRequest(new Object[0]).exchange(this.getRouter()).bodyToMono(ChannelData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<ChannelData> createDM(DMCreateRequest request) {
        return Routes.USER_DM_CREATE.newRequest(new Object[0]).body(request).exchange(this.getRouter()).bodyToMono(ChannelData.class);
    }

    public Mono<ChannelData> createGroupDM(GroupDMCreateRequest request) {
        return Routes.GROUP_DM_CREATE.newRequest(new Object[0]).body(request).exchange(this.getRouter()).bodyToMono(ChannelData.class);
    }

    public Flux<ConnectionData> getUserConnections() {
        return Routes.USER_CONNECTIONS_GET.newRequest(new Object[0]).exchange(this.getRouter()).bodyToMono(ConnectionData[].class).flatMapMany(Flux::fromArray);
    }
}

