/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.rest.http.WriterStrategy;
import discord4j.rest.util.WebhookMultipartRequest;
import java.io.InputStream;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;

@Deprecated
public class WebhookMultipartWriterStrategy
implements WriterStrategy<WebhookMultipartRequest> {
    private static final Logger log = Loggers.getLogger(WebhookMultipartWriterStrategy.class);
    private final ObjectMapper objectMapper;

    public WebhookMultipartWriterStrategy(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canWrite(@Nullable Class<?> type, @Nullable String contentType) {
        return contentType != null && contentType.equals("multipart/form-data") && type == null || type == WebhookMultipartRequest.class;
    }

    @Override
    public Mono<HttpClient.ResponseReceiver<?>> write(HttpClient.RequestSender send, @Nullable WebhookMultipartRequest body) {
        if (body == null) {
            return Mono.empty();
        }
        WebhookExecuteRequest executeRequest = body.getExecuteRequest();
        List<Tuple2<String, InputStream>> files = body.getFiles();
        return Mono.fromCallable(() -> send.sendForm((request, form) -> {
            form.multipart(true);
            if (body.getFiles().size() == 1) {
                form.file("file", (String)((Tuple2)files.get(0)).getT1(), (InputStream)((Tuple2)files.get(0)).getT2(), "application/octet-stream");
            } else {
                for (int i = 0; i < files.size(); ++i) {
                    form.file("file" + i, (String)((Tuple2)files.get(i)).getT1(), (InputStream)((Tuple2)files.get(i)).getT2(), "application/octet-stream");
                }
            }
            if (executeRequest != null) {
                try {
                    String payload = this.objectMapper.writeValueAsString((Object)executeRequest);
                    if (log.isTraceEnabled()) {
                        log.trace("{}", new Object[]{payload});
                    }
                    form.attr("payload_json", payload);
                }
                catch (JsonProcessingException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }));
    }
}

