/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.MessageEditRequest;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestChannel;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestMessage {
    private final RestClient restClient;
    private final long channelId;
    private final long id;

    private RestMessage(RestClient restClient, long channelId, long id) {
        this.restClient = restClient;
        this.channelId = channelId;
        this.id = id;
    }

    public static RestMessage create(RestClient restClient, Snowflake channelId, Snowflake id) {
        return new RestMessage(restClient, channelId.asLong(), id.asLong());
    }

    static RestMessage create(RestClient restClient, long channelId, long id) {
        return new RestMessage(restClient, channelId, id);
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Snowflake getId() {
        return Snowflake.of((long)this.id);
    }

    public RestChannel channel() {
        return RestChannel.create(this.restClient, this.channelId);
    }

    public Mono<MessageData> getData() {
        return this.restClient.getChannelService().getMessage(this.channelId, this.id);
    }

    public Mono<Void> createReaction(String emoji) {
        return this.restClient.getChannelService().createReaction(this.channelId, this.id, emoji);
    }

    public Mono<Void> deleteOwnReaction(String emoji) {
        return this.restClient.getChannelService().deleteOwnReaction(this.channelId, this.id, emoji);
    }

    public Mono<Void> deleteUserReaction(String emoji, Snowflake userId) {
        return this.restClient.getChannelService().deleteReaction(this.channelId, this.id, emoji, userId.asLong());
    }

    public Mono<Void> deleteAllReactions() {
        return this.restClient.getChannelService().deleteAllReactions(this.channelId, this.id);
    }

    public Mono<Void> deleteReactions(String emoji) {
        return this.restClient.getChannelService().deleteReactions(this.channelId, this.id, emoji);
    }

    public Mono<MessageData> edit(MessageEditRequest request) {
        return this.restClient.getChannelService().editMessage(this.channelId, this.id, request);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getChannelService().deleteMessage(this.channelId, this.id, reason);
    }

    public Mono<MessageData> publish() {
        return this.restClient.getChannelService().publishMessage(this.channelId, this.id);
    }
}

