/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.MemberData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestGuild;
import discord4j.rest.entity.RestUser;
import reactor.core.publisher.Mono;

public class RestMember {
    private final RestClient restClient;
    private final long guildId;
    private final long id;

    private RestMember(RestClient restClient, long guildId, long id) {
        this.restClient = restClient;
        this.guildId = guildId;
        this.id = id;
    }

    public static RestMember create(RestClient restClient, Snowflake guildId, Snowflake id) {
        return new RestMember(restClient, guildId.asLong(), id.asLong());
    }

    static RestMember create(RestClient restClient, long guildId, long id) {
        return new RestMember(restClient, guildId, id);
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Snowflake getId() {
        return Snowflake.of((long)this.id);
    }

    public RestGuild guild() {
        return RestGuild.create(this.restClient, this.guildId);
    }

    public RestUser user() {
        return RestUser.create(this.restClient, this.id);
    }

    public Mono<MemberData> getData() {
        return this.restClient.getGuildService().getGuildMember(this.guildId, this.id);
    }
}

