/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.TemplateCreateGuildRequest;
import discord4j.discordjson.json.TemplateData;
import discord4j.rest.RestClient;
import reactor.core.publisher.Mono;

public class RestGuildTemplate {
    private final RestClient restClient;
    private final String code;

    private RestGuildTemplate(RestClient restClient, String code) {
        this.restClient = restClient;
        this.code = code;
    }

    public static RestGuildTemplate create(RestClient restClient, String code) {
        return new RestGuildTemplate(restClient, code);
    }

    public String getCode() {
        return this.code;
    }

    public Mono<TemplateData> getData() {
        return this.restClient.getTemplateService().getTemplate(this.code);
    }

    public Mono<GuildData> createGuild(TemplateCreateGuildRequest request) {
        return this.restClient.getTemplateService().createGuild(this.code, request);
    }
}

