/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.WebhookCreateRequest;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.json.WebhookModifyRequest;
import discord4j.rest.request.DiscordWebResponse;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import discord4j.rest.util.WebhookMultipartRequest;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class WebhookService
extends RestService {
    public WebhookService(Router router) {
        super(router);
    }

    public Mono<WebhookData> createWebhook(long channelId, WebhookCreateRequest request, @Nullable String reason) {
        return Routes.CHANNEL_WEBHOOK_CREATE.newRequest(channelId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(WebhookData.class);
    }

    public Flux<WebhookData> getChannelWebhooks(long channelId) {
        return Routes.CHANNEL_WEBHOOKS_GET.newRequest(channelId).exchange(this.getRouter()).bodyToMono(WebhookData[].class).flatMapMany(Flux::fromArray);
    }

    public Flux<WebhookData> getGuildWebhooks(long guildId) {
        return Routes.GUILD_WEBHOOKS_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(WebhookData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<WebhookData> getWebhook(long webhookId) {
        return Routes.WEBHOOK_GET.newRequest(webhookId).exchange(this.getRouter()).bodyToMono(WebhookData.class);
    }

    public Mono<WebhookData> modifyWebhook(long webhookId, WebhookModifyRequest request, @Nullable String reason) {
        return Routes.WEBHOOK_MODIFY.newRequest(webhookId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(WebhookData.class);
    }

    public Mono<Void> deleteWebhook(long webhookId, @Nullable String reason) {
        return Routes.WEBHOOK_DELETE.newRequest(webhookId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    @Deprecated
    public Mono<MessageData> executeWebhook(long webhookId, String token, boolean wait, WebhookMultipartRequest request) {
        DiscordWebResponse response = Routes.WEBHOOK_EXECUTE.newRequest(webhookId, token).query("wait", wait).header("content-type", request.getFiles().isEmpty() ? "application/json" : "multipart/form-data").body(Objects.requireNonNull(request.getFiles().isEmpty() ? request.getExecuteRequest() : request)).exchange(this.getRouter());
        if (wait) {
            return response.bodyToMono(MessageData.class);
        }
        return response.bodyToMono(Void.class).cast(MessageData.class);
    }

    public Mono<MessageData> modifyWebhookMessage(long webhookId, String webhookToken, String messageId, WebhookMessageEditRequest request) {
        return Routes.WEBHOOK_MESSAGE_EDIT.newRequest(webhookId, webhookToken, messageId).body(request).exchange(this.getRouter()).bodyToMono(MessageData.class);
    }

    public Mono<Void> deleteWebhookMessage(long webhookId, String webhookToken, String messageId) {
        return Routes.WEBHOOK_MESSAGE_DELETE.newRequest(webhookId, webhookToken, messageId).exchange(this.getRouter()).bodyToMono(Void.class);
    }
}

