/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.route.Routes;
import discord4j.rest.util.RouteUtils;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class BucketKey {
    private final String uriTemplate;
    @Nullable
    private final String majorParam;

    private BucketKey(String uriTemplate, String completeUri) {
        this.uriTemplate = uriTemplate;
        this.majorParam = RouteUtils.getMajorParam(uriTemplate, completeUri);
    }

    public static BucketKey of(String uriTemplate, String completeUri) {
        return new BucketKey(uriTemplate, completeUri);
    }

    public static BucketKey of(DiscordWebRequest request) {
        if (Routes.MESSAGE_DELETE.equals(request.getRoute())) {
            return BucketKey.of("DELETE " + request.getRoute().getUriTemplate(), request.getCompleteUri());
        }
        return BucketKey.of(request.getRoute().getUriTemplate(), request.getCompleteUri());
    }

    public int hashCode() {
        return Objects.hash(this.uriTemplate, this.majorParam);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BucketKey bucket = (BucketKey)obj;
        return this.uriTemplate.equals(bucket.uriTemplate) && Objects.equals(this.majorParam, bucket.majorParam);
    }

    public String toString() {
        return Integer.toHexString(this.hashCode());
    }
}

