/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.interaction;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.ApplicationCommandInteractionData;
import discord4j.discordjson.json.ImmutableInteractionResponseData;
import discord4j.discordjson.json.ImmutableWebhookExecuteRequest;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.InteractionResponseData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.rest.RestClient;
import discord4j.rest.interaction.DirectInteraction;
import discord4j.rest.interaction.FollowupInteractionHandler;
import discord4j.rest.interaction.GuildInteraction;
import discord4j.rest.interaction.InteractionMember;
import discord4j.rest.interaction.InteractionMemberOperations;
import discord4j.rest.interaction.InteractionResponse;
import discord4j.rest.interaction.RestInteraction;
import discord4j.rest.util.InteractionResponseType;
import discord4j.rest.util.WebhookMultipartRequest;
import reactor.core.publisher.Mono;

class InteractionOperations
implements RestInteraction,
InteractionResponse,
GuildInteraction,
DirectInteraction {
    private final RestClient restClient;
    private final InteractionData interactionData;
    private final Mono<Long> applicationId;
    private final InteractionMemberOperations memberOperations;

    InteractionOperations(RestClient restClient, InteractionData interactionData, Mono<Long> applicationId) {
        this.restClient = restClient;
        this.interactionData = interactionData;
        this.applicationId = applicationId;
        this.memberOperations = new InteractionMemberOperations(restClient, interactionData);
    }

    @Override
    public Snowflake getGuildId() {
        return Snowflake.of((String)((String)this.interactionData.guildId().get()));
    }

    @Override
    public InteractionMember getInteractionMember() {
        return this.memberOperations;
    }

    @Override
    public UserData getUserData() {
        return (UserData)this.interactionData.user().get();
    }

    @Override
    public InteractionData getData() {
        return this.interactionData;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((String)this.interactionData.id());
    }

    @Override
    public Snowflake getChannelId() {
        return Snowflake.of((String)((String)this.interactionData.channelId().get()));
    }

    @Override
    public ApplicationCommandInteractionData getCommandInteractionData() {
        return (ApplicationCommandInteractionData)this.interactionData.data().get();
    }

    @Override
    public FollowupInteractionHandler acknowledge() {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE.getValue()).data((InteractionApplicationCommandCallbackData)InteractionApplicationCommandCallbackData.builder().build()).build();
        return new FollowupInteractionHandler((InteractionResponseData)responseData, __ -> Mono.empty());
    }

    @Override
    public FollowupInteractionHandler reply(String content) {
        return this.reply((InteractionApplicationCommandCallbackData)InteractionApplicationCommandCallbackData.builder().content(content).build());
    }

    @Override
    public FollowupInteractionHandler reply(InteractionApplicationCommandCallbackData callbackData) {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(InteractionResponseType.CHANNEL_MESSAGE_WITH_SOURCE.getValue()).data(callbackData).build();
        return new FollowupInteractionHandler((InteractionResponseData)responseData, __ -> Mono.empty());
    }

    @Override
    public Mono<MessageData> editInitialResponse(WebhookMessageEditRequest request) {
        return this.applicationId.flatMap(id -> this.restClient.getWebhookService().modifyWebhookMessage((long)id, this.interactionData.token(), "@original", request));
    }

    @Override
    public Mono<Void> deleteInitialResponse() {
        return this.applicationId.flatMap(id -> this.restClient.getWebhookService().deleteWebhookMessage((long)id, this.interactionData.token(), "@original"));
    }

    @Override
    public Mono<MessageData> createFollowupMessage(String content) {
        ImmutableWebhookExecuteRequest body = WebhookExecuteRequest.builder().content(content).build();
        WebhookMultipartRequest request = new WebhookMultipartRequest((WebhookExecuteRequest)body);
        return this.applicationId.flatMap(id -> this.restClient.getWebhookService().executeWebhook((long)id, this.interactionData.token(), true, request));
    }

    @Override
    public Mono<MessageData> createFollowupMessage(WebhookMultipartRequest request, boolean wait) {
        return this.applicationId.flatMap(id -> this.restClient.getWebhookService().executeWebhook((long)id, this.interactionData.token(), wait, request));
    }

    @Override
    public Mono<MessageData> editFollowupMessage(long messageId, WebhookMessageEditRequest request, boolean wait) {
        return this.applicationId.flatMap(id -> this.restClient.getWebhookService().modifyWebhookMessage((long)id, this.interactionData.token(), String.valueOf(messageId), request));
    }
}

