/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.rest.http.DefaultExchangeStrategies;
import discord4j.rest.http.EmptyReaderStrategy;
import discord4j.rest.http.EmptyWriterStrategy;
import discord4j.rest.http.FallbackReaderStrategy;
import discord4j.rest.http.JacksonReaderStrategy;
import discord4j.rest.http.JacksonWriterStrategy;
import discord4j.rest.http.MultipartWriterStrategy;
import discord4j.rest.http.ReaderStrategy;
import discord4j.rest.http.WebhookMultipartWriterStrategy;
import discord4j.rest.http.WriterStrategy;
import java.util.ArrayList;
import java.util.List;

public interface ExchangeStrategies {
    public List<WriterStrategy<?>> writers();

    public List<ReaderStrategy<?>> readers();

    public static ExchangeStrategies jackson(ObjectMapper mapper) {
        ArrayList writerStrategies = new ArrayList();
        writerStrategies.add(new MultipartWriterStrategy(mapper));
        writerStrategies.add(new WebhookMultipartWriterStrategy(mapper));
        writerStrategies.add(new JacksonWriterStrategy(mapper));
        writerStrategies.add(new EmptyWriterStrategy());
        ArrayList readerStrategies = new ArrayList();
        readerStrategies.add(new JacksonReaderStrategy(mapper));
        readerStrategies.add(new EmptyReaderStrategy());
        readerStrategies.add(new FallbackReaderStrategy());
        return new DefaultExchangeStrategies(writerStrategies, readerStrategies);
    }

    public static class Builder {
        private final List<WriterStrategy<?>> writerStrategies = new ArrayList();
        private final List<ReaderStrategy<?>> readerStrategies = new ArrayList();

        public Builder writerStrategy(WriterStrategy<?> writerStrategy) {
            this.writerStrategies.add(writerStrategy);
            return this;
        }

        public Builder readerStrategy(ReaderStrategy<?> readerStrategy) {
            this.readerStrategies.add(readerStrategy);
            return this;
        }

        public ExchangeStrategies build() {
            return new DefaultExchangeStrategies(this.writerStrategies, this.readerStrategies);
        }
    }
}

