/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BulkDeleteRequest;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.FollowedChannelData;
import discord4j.discordjson.json.GroupAddRecipientRequest;
import discord4j.discordjson.json.InviteCreateRequest;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.NewsChannelFollowRequest;
import discord4j.discordjson.json.PermissionsEditRequest;
import discord4j.discordjson.json.WebhookData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestMessage;
import discord4j.rest.util.MultipartRequest;
import discord4j.rest.util.PaginationUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestChannel {
    private final RestClient restClient;
    private final long id;

    private RestChannel(RestClient restClient, long id) {
        this.restClient = restClient;
        this.id = id;
    }

    public static RestChannel create(RestClient restClient, Snowflake id) {
        return new RestChannel(restClient, id.asLong());
    }

    static RestChannel create(RestClient restClient, long id) {
        return new RestChannel(restClient, id);
    }

    public Mono<ChannelData> getData() {
        return this.restClient.getChannelService().getChannel(this.id);
    }

    public RestMessage message(Snowflake messageId) {
        return RestMessage.create(this.restClient, this.id, messageId.asLong());
    }

    public Mono<ChannelData> modify(ChannelModifyRequest request, @Nullable String reason) {
        return this.restClient.getChannelService().modifyChannel(this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getChannelService().deleteChannel(this.id, reason).then();
    }

    public Flux<MessageData> getMessagesBefore(Snowflake messageId) {
        Function doRequest = params -> this.restClient.getChannelService().getMessages(this.id, (Map<String, Object>)params);
        return PaginationUtil.paginateBefore(doRequest, data -> Snowflake.asLong((Id)data.id()), messageId.asLong(), 100);
    }

    public Flux<MessageData> getMessagesAfter(Snowflake messageId) {
        Function doRequest = params -> this.restClient.getChannelService().getMessages(this.id, (Map<String, Object>)params);
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong((Id)data.id()), messageId.asLong(), 100);
    }

    public RestMessage getRestMessage(Snowflake messageId) {
        return RestMessage.create(this.restClient, this.id, messageId.asLong());
    }

    public Mono<MessageData> createMessage(MessageCreateRequest request) {
        return this.restClient.getChannelService().createMessage(this.id, new MultipartRequest(request));
    }

    public Mono<MessageData> createMessage(MultipartRequest request) {
        return this.restClient.getChannelService().createMessage(this.id, request);
    }

    public Mono<MessageData> createMessage(String content) {
        return this.createMessage((MessageCreateRequest)MessageCreateRequest.builder().content(content).build());
    }

    public Mono<MessageData> createMessage(EmbedData embed) {
        return this.createMessage((MessageCreateRequest)MessageCreateRequest.builder().embed(embed).build());
    }

    public Flux<Snowflake> bulkDelete(Publisher<Snowflake> messageIds) {
        Instant timeLimit = Instant.now().minus(Duration.ofDays(14L));
        return Flux.from(messageIds).distinct().buffer(100).flatMap(ids -> {
            ArrayList<String> eligibleIds = new ArrayList<String>(0);
            ArrayList<Snowflake> ineligibleIds = new ArrayList<Snowflake>(0);
            for (Snowflake id : ids) {
                if (id.getTimestamp().isBefore(timeLimit)) {
                    ineligibleIds.add(id);
                    continue;
                }
                eligibleIds.add(id.asString());
            }
            if (eligibleIds.size() == 1) {
                ineligibleIds.add(Snowflake.of((String)((String)eligibleIds.get(0))));
                eligibleIds.clear();
            }
            return Mono.just(eligibleIds).filter(chunk -> !chunk.isEmpty()).flatMap(chunk -> this.restClient.getChannelService().bulkDeleteMessages(this.id, (BulkDeleteRequest)BulkDeleteRequest.builder().messages((Iterable)chunk).build())).thenMany((Publisher)Flux.fromIterable(ineligibleIds));
        });
    }

    public Mono<Void> editChannelPermissions(Snowflake targetId, PermissionsEditRequest request, @Nullable String reason) {
        return this.restClient.getChannelService().editChannelPermissions(this.id, targetId.asLong(), request, reason);
    }

    public Flux<InviteData> getInvites() {
        return this.restClient.getChannelService().getChannelInvites(this.id);
    }

    public Mono<InviteData> createInvite(InviteCreateRequest request, @Nullable String reason) {
        return this.restClient.getChannelService().createChannelInvite(this.id, request, reason);
    }

    public Mono<Void> deleteChannelPermission(Snowflake targetId, @Nullable String reason) {
        return this.restClient.getChannelService().deleteChannelPermission(this.id, targetId.asLong(), reason);
    }

    public Mono<FollowedChannelData> follow(NewsChannelFollowRequest request) {
        return this.restClient.getChannelService().followNewsChannel(this.id, request);
    }

    public Mono<Void> type() {
        return this.restClient.getChannelService().triggerTypingIndicator(this.id);
    }

    public Flux<MessageData> getPinnedMessages() {
        return this.restClient.getChannelService().getPinnedMessages(this.id);
    }

    public Mono<Void> addPinnedMessage(Snowflake messageId) {
        return this.restClient.getChannelService().addPinnedMessage(this.id, messageId.asLong());
    }

    public Mono<Void> deletePinnedMessage(Snowflake messageId) {
        return this.restClient.getChannelService().deletePinnedMessage(this.id, messageId.asLong());
    }

    public Mono<Void> addGroupDMRecipient(Snowflake userId, GroupAddRecipientRequest request) {
        return this.restClient.getChannelService().addGroupDMRecipient(this.id, userId.asLong(), request);
    }

    public Mono<Void> deleteGroupDMRecipient(Snowflake userId) {
        return this.restClient.getChannelService().deleteGroupDMRecipient(this.id, userId.asLong());
    }

    public Flux<WebhookData> getWebhooks() {
        return this.restClient.getWebhookService().getChannelWebhooks(this.id);
    }
}

