/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http.client;

import discord4j.common.GitProperties;
import discord4j.common.LogUtil;
import discord4j.rest.http.ExchangeStrategies;
import discord4j.rest.http.WriterStrategy;
import discord4j.rest.http.client.ClientRequest;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.response.ResponseFunction;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class DiscordWebClient {
    private static final Logger log = Loggers.getLogger(DiscordWebClient.class);
    public static final String KEY_REQUEST_TIMESTAMP = "discord4j.request.timestamp";
    private final HttpClient httpClient;
    private final HttpHeaders defaultHeaders;
    private final ExchangeStrategies exchangeStrategies;
    private final List<ResponseFunction> responseFunctions;

    public DiscordWebClient(HttpClient httpClient, ExchangeStrategies exchangeStrategies, String authorizationScheme, String token, List<ResponseFunction> responseFunctions) {
        Properties properties = GitProperties.getProperties();
        String version = properties.getProperty("git.build.version", "3");
        String url = properties.getProperty("application.url", "https://discord4j.com");
        DefaultHttpHeaders defaultHeaders = new DefaultHttpHeaders();
        defaultHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        defaultHeaders.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)(authorizationScheme + " " + token));
        defaultHeaders.add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)("DiscordBot(" + url + ", " + version + ")"));
        defaultHeaders.add("X-RateLimit-Precision", (Object)"millisecond");
        this.httpClient = httpClient;
        this.defaultHeaders = defaultHeaders;
        this.exchangeStrategies = exchangeStrategies;
        this.responseFunctions = responseFunctions;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpHeaders getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public ExchangeStrategies getExchangeStrategies() {
        return this.exchangeStrategies;
    }

    public Mono<ClientResponse> exchange(ClientRequest request) {
        return Mono.subscriberContext().flatMap(ctx -> {
            HttpHeaders requestHeaders = this.buildHttpHeaders(request);
            String contentType = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            HttpClient.RequestSender sender = (HttpClient.RequestSender)this.httpClient.baseUrl("https://discord.com/api/v6").observe((connection, newState) -> log.trace(LogUtil.format((Context)ctx, (String)"{} {}"), new Object[]{newState, connection})).headers(headers -> headers.setAll(requestHeaders)).request(request.getMethod()).uri(request.getUrl());
            Object body = request.getBody();
            return this.exchangeStrategies.writers().stream().filter(s -> s.canWrite(body != null ? body.getClass() : null, contentType)).findFirst().map(DiscordWebClient::cast).map(writer -> writer.write(sender, body)).orElseGet(() -> Mono.error((Throwable)DiscordWebClient.noWriterException(body, contentType)));
        }).flatMap(receiver -> receiver.responseConnection((response, connection) -> Mono.just((Object)new ClientResponse((HttpClientResponse)response, connection.inbound(), this.exchangeStrategies, request, this.responseFunctions))).next()).subscriberContext(ctx -> ctx.put((Object)KEY_REQUEST_TIMESTAMP, (Object)Instant.now().toEpochMilli()));
    }

    private <R> HttpHeaders buildHttpHeaders(ClientRequest request) {
        HttpHeaders headers = new DefaultHttpHeaders().add(this.defaultHeaders).setAll(request.getHeaders());
        if (request.getBody() == null) {
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        }
        return headers;
    }

    private static <T> WriterStrategy<T> cast(WriterStrategy<?> strategy) {
        return strategy;
    }

    private static RuntimeException noWriterException(@Nullable Object body, String contentType) {
        return new RuntimeException("No strategies to write this request: " + body + " - " + contentType);
    }
}

