/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildEmojiModifyRequest;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestGuild;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestEmoji {
    private final RestClient restClient;
    private final long guildId;
    private final long id;

    private RestEmoji(RestClient restClient, long guildId, long id) {
        this.restClient = restClient;
        this.guildId = guildId;
        this.id = id;
    }

    public static RestEmoji create(RestClient restClient, Snowflake guildId, Snowflake id) {
        return new RestEmoji(restClient, guildId.asLong(), id.asLong());
    }

    static RestEmoji create(RestClient restClient, long guildId, long id) {
        return new RestEmoji(restClient, guildId, id);
    }

    public RestGuild guild() {
        return RestGuild.create(this.restClient, this.guildId);
    }

    public Mono<EmojiData> getData() {
        return this.restClient.getEmojiService().getGuildEmoji(this.guildId, this.id);
    }

    public Mono<EmojiData> modify(GuildEmojiModifyRequest request, @Nullable String reason) {
        return this.restClient.getEmojiService().modifyGuildEmoji(this.guildId, this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getEmojiService().deleteGuildEmoji(this.guildId, this.id, reason);
    }
}

