/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.BanData;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.GuildCreateRequest;
import discord4j.discordjson.json.GuildEmbedData;
import discord4j.discordjson.json.GuildEmbedModifyRequest;
import discord4j.discordjson.json.GuildMemberAddRequest;
import discord4j.discordjson.json.GuildMemberModifyRequest;
import discord4j.discordjson.json.GuildModifyRequest;
import discord4j.discordjson.json.GuildUpdateData;
import discord4j.discordjson.json.GuildWidgetData;
import discord4j.discordjson.json.GuildWidgetModifyRequest;
import discord4j.discordjson.json.IntegrationCreateRequest;
import discord4j.discordjson.json.IntegrationData;
import discord4j.discordjson.json.IntegrationModifyRequest;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.NicknameModifyData;
import discord4j.discordjson.json.PositionModifyRequest;
import discord4j.discordjson.json.PruneData;
import discord4j.discordjson.json.RegionData;
import discord4j.discordjson.json.RoleCreateRequest;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleModifyRequest;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import discord4j.rest.util.Multimap;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class GuildService
extends RestService {
    public GuildService(Router router) {
        super(router);
    }

    public Mono<GuildUpdateData> createGuild(GuildCreateRequest request) {
        return Routes.GUILD_CREATE.newRequest(new Object[0]).body(request).exchange(this.getRouter()).bodyToMono(GuildUpdateData.class);
    }

    public Mono<GuildUpdateData> getGuild(long guildId) {
        return Routes.GUILD_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(GuildUpdateData.class);
    }

    public Mono<GuildUpdateData> modifyGuild(long guildId, GuildModifyRequest request, @Nullable String reason) {
        return Routes.GUILD_MODIFY.newRequest(guildId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(GuildUpdateData.class);
    }

    public Mono<Void> deleteGuild(long guildId) {
        return Routes.GUILD_DELETE.newRequest(guildId).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Flux<ChannelData> getGuildChannels(long guildId) {
        return Routes.GUILD_CHANNELS_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(ChannelData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<ChannelData> createGuildChannel(long guildId, ChannelCreateRequest request, @Nullable String reason) {
        return Routes.GUILD_CHANNEL_CREATE.newRequest(guildId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(ChannelData.class);
    }

    public Flux<RoleData> modifyGuildChannelPositions(long guildId, PositionModifyRequest[] request) {
        return Routes.GUILD_CHANNEL_POSITIONS_MODIFY.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(RoleData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<MemberData> getGuildMember(long guildId, long userId) {
        return Routes.GUILD_MEMBER_GET.newRequest(guildId, userId).exchange(this.getRouter()).bodyToMono(MemberData.class);
    }

    public Flux<MemberData> getGuildMembers(long guildId, Map<String, Object> queryParams) {
        return Routes.GUILD_MEMBERS_LIST.newRequest(guildId).query(queryParams).exchange(this.getRouter()).bodyToMono(MemberData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<MemberData> addGuildMember(long guildId, long userId, GuildMemberAddRequest request) {
        return Routes.GUILD_MEMBER_ADD.newRequest(guildId, userId).body(request).exchange(this.getRouter()).bodyToMono(MemberData.class);
    }

    public Mono<Void> modifyGuildMember(long guildId, long userId, GuildMemberModifyRequest request, @Nullable String reason) {
        return Routes.GUILD_MEMBER_MODIFY.newRequest(guildId, userId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<NicknameModifyData> modifyOwnNickname(long guildId, NicknameModifyData request) {
        return Routes.NICKNAME_MODIFY_OWN.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(NicknameModifyData.class);
    }

    public Mono<Void> addGuildMemberRole(long guildId, long userId, long roleId, @Nullable String reason) {
        return Routes.GUILD_MEMBER_ROLE_ADD.newRequest(guildId, userId, roleId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<Void> removeGuildMemberRole(long guildId, long userId, long roleId, @Nullable String reason) {
        return Routes.GUILD_MEMBER_ROLE_REMOVE.newRequest(guildId, userId, roleId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<Void> removeGuildMember(long guildId, long userId, @Nullable String reason) {
        return Routes.GUILD_MEMBER_REMOVE.newRequest(guildId, userId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Flux<BanData> getGuildBans(long guildId) {
        return Routes.GUILD_BANS_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(BanData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<BanData> getGuildBan(long guildId, long userId) {
        return Routes.GUILD_BAN_GET.newRequest(guildId, userId).exchange(this.getRouter()).bodyToMono(BanData.class);
    }

    public Mono<Void> createGuildBan(long guildId, long userId, Map<String, Object> queryParams, @Nullable String reason) {
        return Routes.GUILD_BAN_CREATE.newRequest(guildId, userId).query(queryParams).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<Void> removeGuildBan(long guildId, long userId, @Nullable String reason) {
        return Routes.GUILD_BAN_REMOVE.newRequest(guildId, userId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Flux<RoleData> getGuildRoles(long guildId) {
        return Routes.GUILD_ROLES_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(RoleData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<RoleData> createGuildRole(long guildId, RoleCreateRequest request, @Nullable String reason) {
        return Routes.GUILD_ROLE_CREATE.newRequest(guildId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(RoleData.class);
    }

    public Flux<RoleData> modifyGuildRolePositions(long guildId, PositionModifyRequest[] request) {
        return Routes.GUILD_ROLE_POSITIONS_MODIFY.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(RoleData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<RoleData> modifyGuildRole(long guildId, long roleId, RoleModifyRequest request, @Nullable String reason) {
        return Routes.GUILD_ROLE_MODIFY.newRequest(guildId, roleId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(RoleData.class);
    }

    public Mono<Void> deleteGuildRole(long guildId, long roleId, @Nullable String reason) {
        return Routes.GUILD_ROLE_DELETE.newRequest(guildId, roleId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    @Deprecated
    public Mono<PruneData> getGuildPruneCount(long guildId, Map<String, Object> queryParams) {
        return Routes.GUILD_PRUNE_COUNT_GET.newRequest(guildId).query(queryParams).exchange(this.getRouter()).bodyToMono(PruneData.class);
    }

    public Mono<PruneData> getGuildPruneCount(long guildId, Multimap<String, Object> params) {
        return Routes.GUILD_PRUNE_COUNT_GET.newRequest(guildId).query(params).exchange(this.getRouter()).bodyToMono(PruneData.class);
    }

    @Deprecated
    public Mono<PruneData> beginGuildPrune(long guildId, Map<String, Object> queryParams, @Nullable String reason) {
        return Routes.GUILD_PRUNE_BEGIN.newRequest(guildId).query(queryParams).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(PruneData.class);
    }

    public Mono<PruneData> beginGuildPrune(long guildId, Multimap<String, Object> params, @Nullable String reason) {
        return Routes.GUILD_PRUNE_BEGIN.newRequest(guildId).query(params).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(PruneData.class);
    }

    public Flux<RegionData> getGuildVoiceRegions(long guildId) {
        return Routes.GUILD_VOICE_REGIONS_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(RegionData[].class).flatMapMany(Flux::fromArray);
    }

    public Flux<InviteData> getGuildInvites(long guildId) {
        return Routes.GUILD_INVITES_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(InviteData[].class).flatMapMany(Flux::fromArray);
    }

    public Flux<IntegrationData> getGuildIntegrations(long guildId) {
        return Routes.GUILD_INTEGRATIONS_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(IntegrationData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<Void> createGuildIntegration(long guildId, IntegrationCreateRequest request) {
        return Routes.GUILD_INTEGRATION_CREATE.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<Void> modifyGuildIntegration(long guildId, long integrationId, IntegrationModifyRequest request) {
        return Routes.GUILD_INTEGRATION_MODIFY.newRequest(guildId, integrationId).body(request).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<Void> deleteGuildIntegration(long guildId, long integrationId) {
        return Routes.GUILD_INTEGRATION_DELETE.newRequest(guildId, integrationId).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<Void> syncGuildIntegration(long guildId, long integrationId) {
        return Routes.GUILD_INTEGRATION_SYNC.newRequest(guildId, integrationId).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    @Deprecated
    public Mono<GuildEmbedData> getGuildEmbed(long guildId) {
        return Routes.GUILD_EMBED_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(GuildEmbedData.class);
    }

    public Mono<GuildWidgetData> getGuildWidget(long guildId) {
        return Routes.GUILD_WIDGET_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(GuildWidgetData.class);
    }

    @Deprecated
    public Mono<GuildEmbedData> modifyGuildEmbed(long guildId, GuildEmbedModifyRequest request) {
        return Routes.GUILD_EMBED_MODIFY.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(GuildEmbedData.class);
    }

    public Mono<GuildWidgetData> modifyGuildWidget(long guildId, GuildWidgetModifyRequest request) {
        return Routes.GUILD_WIDGET_MODIFY.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(GuildWidgetData.class);
    }
}

