/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

public final class Color {
    public static final Color WHITE = Color.of(255, 255, 255);
    public static final Color LIGHT_GRAY = Color.of(192, 192, 192);
    public static final Color GRAY = Color.of(128, 128, 128);
    public static final Color DARK_GRAY = Color.of(64, 64, 64);
    public static final Color BLACK = Color.of(0, 0, 0);
    public static final Color RED = Color.of(255, 0, 0);
    public static final Color PINK = Color.of(255, 175, 175);
    public static final Color ORANGE = Color.of(255, 200, 0);
    public static final Color YELLOW = Color.of(255, 255, 0);
    public static final Color GREEN = Color.of(0, 255, 0);
    public static final Color MAGENTA = Color.of(255, 0, 255);
    public static final Color CYAN = Color.of(0, 255, 255);
    public static final Color BLUE = Color.of(0, 0, 255);
    public static final Color LIGHT_SEA_GREEN = Color.of(1752220);
    public static final Color MEDIUM_SEA_GREEN = Color.of(3066993);
    public static final Color SUMMER_SKY = Color.of(3447003);
    public static final Color DEEP_LILAC = Color.of(10181046);
    public static final Color RUBY = Color.of(15277667);
    public static final Color MOON_YELLOW = Color.of(15844367);
    public static final Color TAHITI_GOLD = Color.of(15105570);
    public static final Color CINNABAR = Color.of(15158332);
    public static final Color SUBMARINE = Color.of(9807270);
    public static final Color HOKI = Color.of(6323595);
    public static final Color DEEP_SEA = Color.of(1146986);
    public static final Color SEA_GREEN = Color.of(2067276);
    public static final Color ENDEAVOUR = Color.of(2123412);
    public static final Color VIVID_VIOLET = Color.of(7419530);
    public static final Color JAZZBERRY_JAM = Color.of(11342935);
    public static final Color DARK_GOLDENROD = Color.of(12745742);
    public static final Color RUST = Color.of(11027200);
    public static final Color BROWN = Color.of(0x992D22);
    public static final Color GRAY_CHATEAU = Color.of(9936031);
    public static final Color BISMARK = Color.of(5533306);
    private final int rgb;

    public static Color of(float red, float green, float blue) {
        return Color.of((int)(red * 255.0f + 0.5f), (int)(green * 255.0f + 0.5f), (int)(blue * 255.0f + 0.5f));
    }

    public static Color of(int red, int green, int blue) {
        if ((red & 0xFF) != red || (green & 0xFF) != green || (blue & 0xFF) != blue) {
            throw new IllegalArgumentException("Illegal RGB arguments red=0x" + Integer.toHexString(red) + " green=0x" + Integer.toHexString(green) + " blue=0x" + Integer.toHexString(blue));
        }
        return Color.of(red << 16 | green << 8 | blue);
    }

    public static Color of(int rgb) {
        return new Color(rgb & 0xFFFFFF);
    }

    private Color(int rgb) {
        this.rgb = rgb;
    }

    public int getRGB() {
        return this.rgb;
    }

    public int getRed() {
        return this.rgb >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.rgb >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.rgb & 0xFF;
    }

    public String toString() {
        return "Color{red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + '}';
    }

    public boolean equals(Object obj) {
        return obj instanceof Color && ((Color)obj).getRGB() == this.getRGB();
    }

    public int hashCode() {
        return this.getRGB();
    }
}

