/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.annotations.Experimental;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.route.Route;
import java.util.Map;
import java.util.function.Predicate;
import reactor.util.annotation.Nullable;

@Experimental
public class RouteMatcher {
    @Nullable
    private final DiscordWebRequest request;
    @Nullable
    private final Predicate<Map<String, String>> requestVariableMatcher;

    private RouteMatcher(DiscordWebRequest request) {
        this(request, null);
    }

    public RouteMatcher(DiscordWebRequest request, Predicate<Map<String, String>> requestVariableMatcher) {
        this.request = request;
        this.requestVariableMatcher = requestVariableMatcher;
    }

    public static RouteMatcher any() {
        return new RouteMatcher(null);
    }

    public static RouteMatcher route(Route route) {
        return new RouteMatcher(route.newRequest(new Object[0]));
    }

    public static RouteMatcher route(Route route, Predicate<Map<String, String>> requestVariableMatcher) {
        return new RouteMatcher(route.newRequest(new Object[0]), requestVariableMatcher);
    }

    public boolean matches(DiscordWebRequest otherRequest) {
        return this.matchesRoute(otherRequest) && this.matchesVariables(otherRequest);
    }

    private boolean matchesRoute(DiscordWebRequest otherRequest) {
        return this.request == null || this.request.getRoute().equals(otherRequest.getRoute());
    }

    private boolean matchesVariables(DiscordWebRequest otherRequest) {
        return this.requestVariableMatcher == null || otherRequest.matchesVariables(this.requestVariableMatcher);
    }
}

