/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.request.RequestQueue;
import discord4j.rest.request.RequestQueueFactory;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;

class ProcessorRequestQueueFactory
implements RequestQueueFactory {
    private final Supplier<FluxProcessor<Object, Object>> processorSupplier;
    private final FluxSink.OverflowStrategy overflowStrategy;

    ProcessorRequestQueueFactory(Supplier<FluxProcessor<Object, Object>> processorSupplier, FluxSink.OverflowStrategy overflowStrategy) {
        this.processorSupplier = processorSupplier;
        this.overflowStrategy = overflowStrategy;
    }

    @Override
    public <T> RequestQueue<T> create() {
        return new RequestQueue<T>(){
            private final FluxProcessor<Object, Object> processor;
            private final FluxSink<Object> sink;
            {
                this.processor = (FluxProcessor)ProcessorRequestQueueFactory.this.processorSupplier.get();
                this.sink = this.processor.sink(FluxSink.OverflowStrategy.BUFFER);
            }

            @Override
            public void push(T request) {
                this.sink.next(request);
            }

            @Override
            public Flux<T> requests() {
                return Flux.create(sink -> this.processor.subscribe(arg_0 -> ((FluxSink)sink).next(arg_0)), (FluxSink.OverflowStrategy)ProcessorRequestQueueFactory.this.overflowStrategy);
            }
        };
    }
}

